<?php
/**
 * Autoloader.
 *
 * @package YITH\AddedToCartPopup
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

if ( ! class_exists( 'YITH_WACP_Autoloader' ) ) {
	/**
	 * Autoloader class.
	 *
	 * @class   YITH_WACP_Autoloader
	 * @since   2.0.0
	 * @author  YITH <plugins@yithemes.com>
	 * @package YITH\AddedToCartPopup
	 */
	class YITH_WACP_Autoloader {

		/**
		 * Path to the includes directory.
		 *
		 * @var string
		 */
		private $include_path = '';

		/**
		 * The Constructor.
		 */
		public function __construct() {
			if ( function_exists( '__autoload' ) ) {
				spl_autoload_register( '__autoload' );
			}

			spl_autoload_register( array( $this, 'autoload' ) );

			$this->include_path = YITH_WACP_INC;
		}

		/**
		 * Take a class name and turn it into a file name.
		 *
		 * @param string $class Class name.
		 *
		 * @return string
		 */
		private function get_file_name_from_class( $class ) {
			$filename = '';
			$base     = str_replace( '_', '-', $class );

			if ( false !== strpos( $class, 'interface' ) ) {
				$filename = 'interface-' . $base . '.php';
			} elseif ( false !== strpos( $class, 'trait' ) ) {
				$base     = str_replace( '-trait', '', $base );
				$filename = 'trait-' . $base . '.php';
			}

			if ( empty( $filename ) ) {
				$filename = 'class-' . $base . '.php';
			}

			return $filename;
		}

		/**
		 * Include a class file.
		 *
		 * @param string $path File path.
		 *
		 * @return bool Successful or not.
		 */
		private function load_file( $path ) {
			if ( $path && is_readable( $path ) ) {
				include_once $path;

				return true;
			}

			return false;
		}

		/**
		 * Auto-load plugins' classes on demand to reduce memory consumption.
		 *
		 * @param string $class Class name.
		 */
		public function autoload( $class ) {
			$class = strtolower( $class );

			if ( 0 !== strpos( $class, 'yith_wacp' ) ) {
				return;
			}

			$file = $this->get_file_name_from_class( $class );
			$path = '';

			if ( false !== strpos( $class, 'trait' ) ) {
				$path = $this->include_path . 'traits/';
			} elseif ( false !== strpos( $class, 'frontend' ) || false !== strpos( $class, 'mini_cart' ) ) {
				$path = $this->include_path . 'frontend/';
			} elseif ( false !== strpos( $class, 'integration' ) ) {
				$path = $this->include_path . 'integrations/';
			} elseif ( false !== strpos( $class, 'admin_table' ) ) {
				$path = $this->include_path . 'admin/admin-tables/';
			} elseif ( false !== strpos( $class, 'admin' ) ) {
				$path = $this->include_path . 'admin/';
			}

			if ( empty( $path ) || ! $this->load_file( $path . $file ) ) {
				$this->load_file( $this->include_path . $file );
			}
		}
	}
}

new YITH_WACP_Autoloader();
