/**
 * Admin Scripts
 *
 * @package YITH\AddedToCartPopup\Assets\JS
 */

jQuery(
	function ( $ ) {
		/**
		 * Dependencies on cart totals
		 */
		$( '#yith-wacp-show-cart-shipping, #yith-wacp-show-cart-tax' ).on(
			'change',
			function () {
				if ( $( this ).val() === 'yes' ) {
					$( '#yith-wacp-shipping-taxes-label-color' ).parents( 'tr' ).show( 500 );
				}
				if ( $( '#yith-wacp-show-cart-shipping' ).val() === 'no' && $( '#yith-wacp-show-cart-tax' ).val() === 'no' ) {
					$( '#yith-wacp-shipping-taxes-label-color' ).parents( 'tr' ).hide();
				}
			}
		).trigger( 'change' );

		/**
		 * Dependencies on Customizations->Upsell-Cross-Sell
		 */
		$( '#yith-wacp-show-related' ).on(
			'change',
			function () {
				if ( $( this ).val() === "yes" ) {
					$( this ).parents( 'tr' ).nextAll( 'tr' ).show( 500 );
					if ( $( '#yith-wacp-suggested-products-type' ).val() !== 'specific_products' ) {
						$( '#yith-wacp-related-products' ).parents( 'tr' ).hide();
					}

				} else {
					$( this ).parents( 'tr' ).nextAll( 'tr' ).hide();
				}
			}
		).trigger( 'change' );

		/**
		 * Dependencies on Customizations->Buttons
		 */
		$( '#yith-wacp-show-go-cart, #yith-wacp-show-go-checkout, #yith-wacp-show-continue-shopping' ).on(
			'change',
			function () {
				if ( $( this ).val() === 'yes' ) {
					$( '#yith-wacp-button-border-radius' ).parents( 'tr' ).show( 500 );
				}
				if ( $( '#yith-wacp-show-go-cart' ).val() === 'no' && $( '#yith-wacp-show-go-checkout' ).val() === 'no' && $( '#yith-wacp-show-continue-shopping' ).val() === 'no' ) {
					$( '#yith-wacp-button-border-radius' ).parents( 'tr' ).hide();
				}
			}
		).trigger( 'change' );

		/**
		 * Exclusion list handlers
		 */
		var newExclusion     = $( document ).find( '.yith-exclusion-list__popup_wrapper' ),
			confirm          = $( document ).find( '.yith-exclusion-list__delete_row' ),
			popupForm        = newExclusion.find( 'form' ),
			openPopup        = function () {

				newExclusion = $( document ).find( '.yith-exclusion-list__popup_wrapper' );

				newExclusion.dialog(
					{
						closeText  : '',
						title      : yith_wacp_exclusion_list.popup_add_title,
						width      : 500,
						modal      : true,
						dialogClass: 'yith-plugin-ui yith-wacp-exclusion-list-add yith-wacp-exclusion-list-popup',
						buttons    : [{
							'text' : yith_wacp_exclusion_list.save,
							'click': function ( e ) {
								e.preventDefault();
								window.onbeforeunload = null;
								popupForm.submit();
							},
							'class': 'yith-save-button'
						}]
					}
				);

			},
			updatePopupField = function () {
				$( document ).on(
					'change',
					'#yith-wacp-exclusion-type',
					function () {
						var fieldSelected = $( this ).val();
						$( '.form-table tr:not(.yith-wacp-exclusion-type)' ).hide();
						$( '.form-table tr.' + fieldSelected ).show();
					}
				);

				$( '#yith-wacp-exclusion-type' ).change();
			},
			cancelExclusion  = function ( fieldType, fieldId ) {
				$.ajax(
					{
						url    : yith_wacp_exclusion_list.ajaxurl,
						data   : {
							type  : fieldType,
							id    : fieldId,
							action: 'yith_wacp_delete_from_exclusion_list',
							nonce : yith_wacp_exclusion_list.delete_nonce
						},
						type   : 'POST',
						success: function () {
							confirm.dialog( 'close' );
							window.location.reload();
						}
					}
				);
			};

		updatePopupField();

		$( document ).on(
			'click',
			'.yith-wacp-add-exclusions',
			function () {
				openPopup();
			}
		);

		$( document ).on(
			'click',
			'.action__trash',
			function ( ev ) {
				ev.preventDefault();

				var $t        = $( this ),
					$row      = $t.closest( 'tr' ),
					fieldId   = $row.find( '.check-column input' ).val(),
					fieldType = $row.find( '.yith-wacp-data-type' ).data( 'type' );

				var confirmButton = {
					'text' : yith_wacp_exclusion_list.confirmChoice,
					'click': function () {
						cancelExclusion( fieldType, fieldId );
					},
					'class': 'yith-plugin-fw__button--delete'
				};

				var closeButton = {
					'text' : yith_wacp_exclusion_list.cancel,
					'click': function () {
						confirm.dialog( "close" );
					},
					'class': 'yith-plugin-fw__button--secondary'
				};

				confirm.dialog(
					{
						closeText  : '',
						width      : 350,
						modal      : true,
						dialogClass: 'yith-plugin-ui yith-wacp-exclusion-list-popup-confirmation yith-wacp-exclusion-list-popup',
						buttons    : [
							confirmButton,
							closeButton
						]

					}
				);
			}
		);

		/**
		 * Draggable item function.
		 */
		$( '#yith-wacp-mini-cart-position_draggable' ).draggable(
			{
				containment: '#yith-wacp-mini-cart-position_draggable_container',
				create     : function () {
					let top  = 270 * ( $( '#yith-wacp-mini-cart-position_top' ).val() / 100 ),
						left = 320 * ( $( '#yith-wacp-mini-cart-position_left' ).val() / 100 );

					$( this ).css(
						{
							'top' : top,
							'left': left
						}
					).show();
				},
				stop       : function ( event, ui ) {
					let top  = ( ui.position.top + 30 ) / 3,
						left = ( ui.position.left + 30 ) / 3.5;

					$( '#yith-wacp-mini-cart-position_top' ).val( top );
					$( '#yith-wacp-mini-cart-position_left' ).val( left );
				}
			}
		);

		$( '.wp-picker-holder, #yith-wacp-mini-cart-border-radius input, #yith-wacp-mini-cart-icon, #yith-wacp-mini-cart-icon-type' ).on(
			'change keyup input keydown keypress click mousemove',
			function () {
				var icon       = $( '#yith-wacp-mini-cart-position_draggable' ),
					field_name = '#yith-wacp-mini-cart-border-radius-dimension-',
					dimensions = $( field_name + 'top' ).val() + 'px ' + $( field_name + 'right' ).val() + 'px ' + $( field_name + 'bottom' ).val() + 'px ' + $( field_name + 'left' ).val() + 'px ';
				icon
					.css( '--wacp-mini-cart-border-radius', dimensions )
					.css( '--wacp-mini-cart-icon-color', $( '#yith-wacp-mini-cart-icon-color' ).val() )
					.css( '--wacp-mini-cart-bg-color', $( '#yith-wacp-mini-cart-colors_background' ).val() )
					.css( '--wacp-mini-cart-shadow-color', $( '#yith-wacp-mini-cart-colors_shadow' ).val() );

				if ( 'default' === $( '#yith-wacp-mini-cart-icon-type' ).val() ) {
					icon.removeClass( 'custom-icon' );
					icon.addClass( 'default-icon' );
					icon.css( 'background-image', 'none' );
				} else {
					icon.addClass( 'custom-icon' );
					icon.removeClass( 'default-icon' );
					$( '#yith-wacp-mini-cart-position_draggable.custom-icon' ).css( 'background-image', 'url(' + $( '#yith-wacp-mini-cart-icon' ).val() + ')' );
				}
			}
		).trigger( 'change' );

		moveExclusionListButton = function() {
			let exclusionListSection = $( '#yith_wacp_panel_exclusions' ),
				addBlockButton = exclusionListSection.find( '.yith-wacp-add-exclusions' ),
				contentTitle = exclusionListSection.find( '.yith-plugin-fw__panel__content__page .yith-plugin-fw__panel__content__page__title' );

			contentTitle.after( addBlockButton );
		};

		moveExclusionListButton();

	}
);
