<?php
/**
 * Admin class
 *
 * @package YITH\AddedToCartPopup\Admin
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

if ( ! class_exists( 'YITH_WACP_Admin' ) ) {

	/**
	 * Admin class.
	 * The class manage all the admin behaviors.
	 *
	 * @class   YITH_WACP_Admin
	 * @since   1.0.0
	 * @author  YITH <plugins@yithemes.com>
	 * @package YITH\AddedToCartPopup\Admin
	 */
	class YITH_WACP_Admin {

		use YITH_WACP_Trait_Singleton;

		/**
		 * Plugin options
		 *
		 * @since  1.0.0
		 * @var array
		 * @access public
		 */
		public $options = array();

		/**
		 * The plugin panel object
		 *
		 * @var object
		 */
		protected $panel;

		/**
		 * Premium tab template file name
		 *
		 * @var string
		 */
		protected $premium = 'premium.php';

		/**
		 * Added to Cart Popup panel page
		 *
		 * @var string
		 */
		protected $panel_page = 'yith_wacp_panel';

		/**
		 * Constructor
		 *
		 * @access public
		 * @since  1.0.0
		 */
		public function __construct() {
			add_action( 'admin_menu', array( $this, 'register_panel' ), 5 );
			add_action( 'admin_footer', array( $this, 'plugin_fw_customizations' ) );

			// Add action links.
			add_filter( 'plugin_action_links_' . plugin_basename( YITH_WACP_DIR . '/' . basename( YITH_WACP_FILE ) ), array( $this, 'action_links' ) );
			add_filter( 'yith_show_plugin_row_meta', array( $this, 'plugin_row_meta' ), 10, 3 );
		}

		/**
		 * Action Links. Add the action links to plugin admin page
		 *
		 * @param array $links An array of action links.
		 *
		 * @return   array
		 * @use      plugin_action_links_{$plugin_file_name}
		 * @since    1.0.0
		 */
		public function action_links( $links ) {
			$links = yith_add_action_links( $links, $this->panel_page, true, YITH_WACP_SLUG );

			return $links;
		}

		/**
		 * Add a panel under YITH Plugins tab
		 *
		 * @return   void
		 * @since    1.0
		 * @use      /Yit_Plugin_Panel class
		 * @see      plugin-fw/lib/yit-plugin-panel.php
		 */
		public function register_panel() {
			if ( ! empty( $this->panel ) ) {
				return;
			}

			$admin_tabs = array(
				'general-settings' => array(
					'title'       => esc_html__( 'General Options', 'yith-woocommerce-added-to-cart-popup' ),
					'description' => esc_html__( 'Set the general options for the plugin behavior', 'yith-woocommerce-added-to-cart-popup' ),
					'icon'        => 'settings',
				),
			);

			$args = array(
				'ui_version'       => 2,
				'create_menu_page' => true,
				'parent_slug'      => '',
				'page_title'       => 'YITH WooCommerce Added to Cart Popup',
				'menu_title'       => 'Added to Cart Popup',
				'capability'       => 'manage_options',
				'parent'           => '',
				'parent_page'      => 'yith_plugin_panel',
				'page'             => $this->panel_page,
				/**
				 * APPLY_FILTERS: yith_wacp_admin_tabs
				 *
				 * Manages admin tabs.
				 *
				 * @param array $admin_tabs The admin tabs array..
				 */
				'admin-tabs'       => apply_filters( 'yith_wacp_admin_tabs', $admin_tabs ),
				'options-path'     => YITH_WACP_DIR . '/plugin-options',
				'plugin_slug'      => YITH_WACP_SLUG,
				'class'            => yith_set_wrapper_class(),
				'is_premium'       => true,
				'your_store_tools' => array(
					'items' => array(
						'wishlist'               => array(
							'name'           => 'Wishlist',
							'icon_url'       => YITH_WACP_ASSETS_URL . '/images/plugins/wishlist.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-wishlist/',
							'description'    => _x(
								'Allow your customers to create lists of products they want and share them with family and friends.',
								'[YOUR STORE TOOLS TAB] Description for plugin YITH WooCommerce Wishlist',
								'yith-woocommerce-added-to-cart-popup'
							),
							'is_active'      => defined( 'YITH_WCWL_PREMIUM' ),
							'is_recommended' => true,
						),
						'gift-cards'             => array(
							'name'           => 'Gift Cards',
							'icon_url'       => YITH_WACP_ASSETS_URL . '/images/plugins/gift-cards.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-gift-cards/',
							'description'    => _x(
								'Sell gift cards in your shop to increase your earnings and attract new customers.',
								'[YOUR STORE TOOLS TAB] Description for plugin YITH WooCommerce Gift Cards',
								'yith-woocommerce-added-to-cart-popup'
							),
							'is_active'      => defined( 'YITH_YWGC_PREMIUM' ),
							'is_recommended' => true,
						),
						'request-a-quote'        => array(
							'name'           => 'Request a Quote',
							'icon_url'       => YITH_WACP_ASSETS_URL . '/images/plugins/request-a-quote.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-request-a-quote/',
							'description'    => _x(
								'Hide prices and/or the "Add to cart" button and let your customers request a custom quote for every product.',
								'[YOUR STORE TOOLS TAB] Description for plugin YITH WooCommerce Request a Quote',
								'yith-woocommerce-added-to-cart-popup'
							),
							'is_active'      => defined( 'YITH_YWRAQ_PREMIUM' ),
							'is_recommended' => false,
						),
						'ajax-product-filter'    => array(
							'name'           => 'Ajax Product Filter',
							'icon_url'       => YITH_WACP_ASSETS_URL . '/images/plugins/ajax-product-filter.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-ajax-product-filter/',
							'description'    => _x(
								'Help your customers to easily find the products they are looking for and improve the user experience of your shop.',
								'[YOUR STORE TOOLS TAB] Description for plugin YITH WooCommerce Ajax Product Filter',
								'yith-woocommerce-added-to-cart-popup'
							),
							'is_active'      => defined( 'YITH_WCAN_PREMIUM' ),
							'is_recommended' => false,
						),
						'product-addons'         => array(
							'name'           => 'Product Add-Ons & Extra Options',
							'icon_url'       => YITH_WACP_ASSETS_URL . '/images/plugins/product-add-ons.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-product-add-ons/',
							'description'    => _x(
								'Add paid or free advanced options to your product pages using fields like radio buttons, checkboxes, drop-downs, custom text inputs, and more.',
								'[YOUR STORE TOOLS TAB] Description for plugin YITH WooCommerce Product Add-Ons',
								'yith-woocommerce-added-to-cart-popup'
							),
							'is_active'      => defined( 'YITH_WAPO_PREMIUM' ),
							'is_recommended' => false,
						),
						'dynamic-pricing'        => array(
							'name'           => 'Dynamic Pricing and Discounts',
							'icon_url'       => YITH_WACP_ASSETS_URL . '/images/plugins/dynamic-pricing-and-discounts.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-dynamic-pricing-and-discounts/',
							'description'    => _x(
								'Increase conversions through dynamic discounts and price rules, and build powerful and targeted offers.',
								'[YOUR STORE TOOLS TAB] Description for plugin YITH WooCommerce Dynamic Pricing and Discounts',
								'yith-woocommerce-added-to-cart-popup'
							),
							'is_active'      => defined( 'YITH_YWDPD_PREMIUM' ),
							'is_recommended' => false,
						),
						'customize-my-account'   => array(
							'name'           => 'Customize My Account Page',
							'icon_url'       => YITH_WACP_ASSETS_URL . '/images/plugins/customize-myaccount-page.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-customize-my-account-page/',
							'description'    => _x(
								'Customize the My Account page of your customers by creating custom sections with promotions and ad-hoc content based on your needs.',
								'[YOUR STORE TOOLS TAB] Description for plugin YITH WooCommerce Customize My Account',
								'yith-woocommerce-added-to-cart-popup'
							),
							'is_active'      => defined( 'YITH_WCMAP_PREMIUM' ),
							'is_recommended' => false,
						),
						'recover-abandoned-cart' => array(
							'name'           => 'Recover Abandoned Cart',
							'icon_url'       => YITH_WACP_ASSETS_URL . '/images/plugins/recover-abandoned-cart.svg',
							'url'            => '//yithemes.com/themes/plugins/yith-woocommerce-recover-abandoned-cart/',
							'description'    => _x(
								'Contact users who have added products to the cart without completing the order and try to recover lost sales.',
								'[YOUR STORE TOOLS TAB] Description for plugin Recover Abandoned Cart',
								'yith-woocommerce-added-to-cart-popup'
							),
							'is_active'      => defined( 'YITH_YWRAC_PREMIUM' ),
							'is_recommended' => false,
						),
					),
				),
				'help_tab'         => array(
					'hc_url'     => '',
					'doc_url'    => 'https://docs.yithemes.com/yith-woocommerce-added-to-cart-popup/',
					'main_video' => array(
						//'desc' => _x( 'Check this video to learn how to <b>create and set up an online auction:</b>', '[HELP TAB] Video title', 'yith-auctions-for-woocommerce' ),
						'url' => array(
							'en' => 'https://www.youtube.com/embed/99Sk3RGMiyE?si=w3Ypo-jn1CTyKNG6',
							'it' => 'https://www.youtube.com/embed/nMa4Zvuhgpw?si=LX_0KcdJ9qab5D1',
							'es' => 'https://www.youtube.com/embed/AlBFaZdf5Sw?si=Y7JV_ayNtTe64VIS',
						),
					),
				),
				'welcome_modals'   => array(
					'show_in'  => 'first_page',
					'on_close' => function () {
						update_option( 'yith-woocommerce-added-to-cart-popup-welcome-modal', 'no' );
					},
					'modals'   => array(
						'welcome' => array(
							'type'        => 'welcome',
							'description' => __( 'Show a popup when a new product is added to the cart to improve the user experience and promote upsell products', 'yith-woocommerce-added-to-cart-popup' ),
							'show'        => get_option( 'yith-woocommerce-added-to-cart-popup-welcome-modal', 'welcome' ) === 'welcome',
							'items'       => array(
								'documentation' => array(
									'url' => 'https://docs.yithemes.com/yith-woocommerce-added-to-cart-popup/',
								),
								'how-to-video'  => array(
									'url' => array(
										'en' => 'https://www.youtube.com/watch?v=99Sk3RGMiyE',
										'it' => 'https://www.youtube.com/watch?v=nMa4Zvuhgpw',
										'es' => 'https://www.youtube.com/watch?v=AlBFaZdf5Sw',
									),
								),
								'feature'       => array(
									'title'       => __( '<mark>Customize the content and style</mark> of the modal window', 'yith-woocommerce-added-to-cart-popup' ),
									'description' => __( 'and embark on this new adventure!', 'yith-woocommerce-added-to-cart-popup' ),
									'url'         => add_query_arg(
										array(
											'page' => 'yith_wacp_panel',
											'tab'  => 'customization',
										),
										admin_url( 'admin.php' )
									),
								),
							),
						),
					),
				),
			);

			if ( ! class_exists( 'YIT_Plugin_Panel_WooCommerce' ) ) {
				require_once YITH_WACP_DIR . '/plugin-fw/lib/yit-plugin-panel-wc.php';
			}

			$this->panel = new YIT_Plugin_Panel_WooCommerce( $args );
		}

		/**
		 * Plugin-fw customizations.
		 */
		public function plugin_fw_customizations() {
			if ( isset( $_GET['page'] ) && 'yith_wacp_panel' === $_GET['page'] ) : // phpcs:ignore WordPress.Security.NonceVerification.Recommended ?>
				<style>
					.select2-search__field { width: auto !important; }
					/* DIALOG */
					.yith-plugins_page_yith_wacp_panel .ui-widget-overlay.ui-front { background-color: rgba(34, 59, 80, 0.7) !important; opacity: 1 !important; }
					.yith-wacp-exclusion-list-popup-confirmation { padding: 0 !important; box-shadow: rgba(0, 22, 59, 0.4) 1px 3px 16px 0px !important; }
					.yith-wacp-exclusion-list-popup-confirmation .ui-dialog-titlebar { height: 30px !important; line-height: 30px !important; padding: 20px 25px !important; }
					.yith-wacp-exclusion-list-popup-confirmation .ui-dialog-titlebar span { padding: 0 !important; margin: 0 !important; font-size: 19.5px !important; font-weight: 600 !important; }
					.yith-wacp-exclusion-list-popup-confirmation .ui-dialog-titlebar button { width: auto !important; height: auto !important; padding: 8px !important; margin: 0 !important; top: 0 !important; right: 0 !important; }
					.yith-wacp-exclusion-list-popup-confirmation .ui-dialog-titlebar button:before { content: "\e906" !important; font: 14px 'yith-icon' !important; font-weight: 600 !important; color: #aaa !important; }
					.yith-wacp-exclusion-list-popup-confirmation .ui-dialog-titlebar button:hover:before { color: #333 !important; }
					.yith-wacp-exclusion-list-popup-confirmation .yith-exclusion-list__delete_row.ui-dialog-content { padding: 0 25px !important; margin-bottom: 20px !important; }
					.yith-wacp-exclusion-list-popup-confirmation .yith-exclusion-list__delete_row.ui-dialog-content p { margin: 0 !important; }
					.yith-wacp-exclusion-list-popup-confirmation .ui-dialog-buttonpane { padding: 0 25px 25px 25px !important; margin: 0 !important; }
					.yith-wacp-exclusion-list-popup-confirmation .ui-dialog-buttonset { padding: 0 !important; }
					.yith-wacp-exclusion-list-popup-confirmation .ui-dialog-buttonset button { float: right !important; }
					.yith-wacp-exclusion-list-popup-confirmation .yith-plugin-fw__button--delete { line-height: 33px !important; background: var(--yith-primary) !important; color: var(--yith-primary-text) !important; border: 1px solid var(--yith-primary) !important; margin: 0 !important; box-shadow: none !important; }
					.yith-wacp-exclusion-list-popup-confirmation .yith-plugin-fw__button--secondary { line-height: 33px !important; background: var(--yith-outline-bg) !important; border: 1px solid var(--yith-outline-border) !important; margin: 0 10px 0 0 !important; color: var(--yith-outline-text) !important; box-shadow: none !important; }
				</style>
				<script>
					jQuery('#yith-wacp-show-cart-shipping, #yith-wacp-show-cart-tax').change( function() {
						let wacpToggleContainer = jQuery('#yith-wacp-shipping-taxes-label-color_label').parent().parent().parent().parent().parent().parent().parent().parent().parent();
						let wacpShowCartShipping = jQuery('#yith-wacp-show-cart-shipping').val();
						let wacpShowCartTax = jQuery('#yith-wacp-show-cart-tax').val();
						if ( wacpShowCartShipping == 'yes' || wacpShowCartTax == 'yes' ) { wacpToggleContainer.show(); }
						else { wacpToggleContainer.hide(); }
					});
					jQuery('#yith-wacp-show-go-cart, #yith-wacp-show-go-checkout, #yith-wacp-show-continue-shopping').change( function() {
						let wacpToggleContainer = jQuery('#yith-wacp-button-border-radius-dimension-right').parent().parent().parent().parent().parent().parent().parent().parent();
						let wacpShowGoCart = jQuery('#yith-wacp-show-go-cart').val();
						let wacpShowGoCheckout = jQuery('#yith-wacp-show-go-checkout').val();
						let wacpShowContinue = jQuery('#yith-wacp-show-continue-shopping').val();
						if ( wacpShowGoCart == 'yes' || wacpShowGoCheckout == 'yes' || wacpShowContinue == 'yes' ) { wacpToggleContainer.show(); }
						else { wacpToggleContainer.hide(); }
					});
				</script>
				<?php
			endif;
		}

		/**
		 * Add plugin row metas
		 *
		 * @param array    $new_row_meta_args An array of plugin row meta.
		 * @param string[] $plugin_meta       An array of the plugin's metadata,
		 *                                    including the version, author,
		 *                                    author URI, and plugin URI.
		 * @param string   $plugin_file       Path to the plugin file relative to the plugins directory.
		 *
		 * @return array
		 * @since  1.0.0
		 */
		public function plugin_row_meta( $new_row_meta_args, $plugin_meta, $plugin_file ) {
			if ( defined( 'YITH_WACP_INIT' ) && YITH_WACP_INIT === $plugin_file ) {
				$new_row_meta_args['slug'] = YITH_WACP_SLUG;

				if ( defined( 'YITH_WACP_EXTENDED' ) ) {
					$new_row_meta_args['is_extended'] = true;
				}

				if ( defined( 'YITH_WACP_PREMIUM' ) ) {
					$new_row_meta_args['is_premium'] = true;
				}
			}

			return $new_row_meta_args;
		}
	}
}
