<?php
/**
 * General Function
 *
 * @author YITH <plugins@yithemes.com>
 * @package YITH\AddedToCartPopup\
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

if ( ! function_exists( 'yith_wacp_gb_pixel_plugin' ) ) {
	/**
	 * Compatibility with FB Pixel Plugin
	 *
	 * @param integer $product_id The product ID.
	 *
	 * @return void
	 */
	function yith_wacp_gb_pixel_plugin( $product_id ) {

		if ( ! function_exists( 'pys_add_event' ) ) {
			return;
		}

		$variation_id = isset( $_REQUEST['variation_id'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['variation_id'] ) ) : '';//phpcs:ignore WordPress.Security.NonceVerification.Recommended
		if ( pys_get_option( 'woo', 'variation_id' ) === 'variation' && '' !== $variation_id ) {
			$product_id = absint( $variation_id );
		}

		$params = function_exists( 'pys_get_woo_product_addtocart_params' ) ? pys_get_woo_product_addtocart_params( $product_id ) : pys_get_woo_ajax_addtocart_params( $product_id );

		pys_add_event( 'AddToCart', $params );
	}
}

add_action( 'woocommerce_ajax_added_to_cart', 'yith_wacp_gb_pixel_plugin', 99, 1 );
