<?php
/**
 * Plugin Name: YITH WooCommerce Added to Cart Popup Premium
 * Plugin URI: https://yithemes.com/themes/plugins/yith-woocommerce-added-to-cart-popup/
 * Description: The <code><strong>YITH WooCommerce Added to Cart Popup</strong></code> plugin allows you to display a popup cart with suggested products and cart actions after an "add to cart" action. <a href="https://yithemes.com/" target="_blank">Get more plugins for your e-commerce shop on <strong>YITH</strong></a>.
 * Version: 2.33.0
 * Author: YITH
 * Author URI: https://yithemes.com/
 * Text Domain: yith-woocommerce-added-to-cart-popup
 * Domain Path: /languages/
 * Requires Plugins: woocommerce
 * WC requires at least: 10.1
 * WC tested up to: 10.3
 *
 * @author YITH <plugins@yithemes.com>
 * @package YITH\AddedToCartPopup
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

if ( ! function_exists( 'is_plugin_active' ) ) {
	require_once ABSPATH . 'wp-admin/includes/plugin.php';
}

/**
 * Premium install error admin notice
 *
 * @return void
 * @since  1.0.0
 */
function yith_wacp_premium_install_woocommerce_admin_notice() {
	?>
	<div class="error">
		<p>
			<?php
			/* translators: %s name of the plugin */
			echo sprintf( esc_html__( '%s is enabled but not effective. It requires WooCommerce in order to work.', 'yith-woocommerce-added-to-cart-popup' ), 'YITH WooCommerce Added to Cart Popup Premium' );
			?>
		</p>
	</div>
	<?php
}

if ( ! function_exists( 'yith_plugin_registration_hook' ) ) {
	require_once 'plugin-fw/yit-plugin-registration-hook.php';
}
register_activation_hook( __FILE__, 'yith_plugin_registration_hook' );

if ( ! function_exists( 'yith_plugin_onboarding_registration_hook' ) ) {
	include_once 'plugin-upgrade/functions-yith-licence.php';
}
register_activation_hook( __FILE__, 'yith_plugin_onboarding_registration_hook' );

! defined( 'YITH_WACP_VERSION' ) && define( 'YITH_WACP_VERSION', '2.33.0' );
! defined( 'YITH_WACP_PREMIUM' ) && define( 'YITH_WACP_PREMIUM', '1' );
! defined( 'YITH_WACP' ) && define( 'YITH_WACP', true );
! defined( 'YITH_WACP_FILE' ) && define( 'YITH_WACP_FILE', __FILE__ );
! defined( 'YITH_WACP_URL' ) && define( 'YITH_WACP_URL', plugin_dir_url( __FILE__ ) );
! defined( 'YITH_WACP_DIR' ) && define( 'YITH_WACP_DIR', plugin_dir_path( __FILE__ ) );
! defined( 'YITH_WACP_INC' ) && define( 'YITH_WACP_INC', YITH_WACP_DIR . 'includes/' );
! defined( 'YITH_WACP_TEMPLATE_PATH' ) && define( 'YITH_WACP_TEMPLATE_PATH', YITH_WACP_DIR . 'templates' );
! defined( 'YITH_WACP_VIEWS_PATH' ) && define( 'YITH_WACP_VIEWS_PATH', YITH_WACP_DIR . 'views' );
! defined( 'YITH_WACP_ASSETS_URL' ) && define( 'YITH_WACP_ASSETS_URL', YITH_WACP_URL . 'assets' );
! defined( 'YITH_WACP_INIT' ) && define( 'YITH_WACP_INIT', plugin_basename( __FILE__ ) );
! defined( 'YITH_WACP_SLUG' ) && define( 'YITH_WACP_SLUG', 'yith-woocommerce-added-to-cart-popup' );
! defined( 'YITH_WACP_SECRET_KEY' ) && define( 'YITH_WACP_SECRET_KEY', 'T05qW0KkKsgW2B5PsTqS' );

// Plugin Framework Loader.
if ( file_exists( plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php' ) ) {
    require_once plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php';
}

/**
 * Init plugin
 *
 * @return void
 * @since  1.0.0
 */
function yith_wacp_premium_init() {
	if ( function_exists( 'yith_plugin_fw_load_plugin_textdomain' ) ) {
		yith_plugin_fw_load_plugin_textdomain( 'yith-woocommerce-added-to-cart-popup', basename( dirname( __FILE__ ) ) . '/languages' );
	}

	// Let's start the game!
	YITH_WACP();
}

/**
 * Unique access to instance of YITH_WACP
 *
 * @return  object
 * @since   2.0.0
 */
function YITH_WACP() { //phpcs:ignore WordPress.NamingConventions.ValidFunctionName.FunctionNameInvalid
	// Load required classes and functions.
	require_once YITH_WACP_INC . 'class-yith-wacp-autoloader.php';

	return YITH_WACP::get_instance();

}

add_action( 'yith_wacp_premium_init', 'yith_wacp_premium_init' );

/**
 * Premium plugin install process
 *
 * @return void
 * @since  1.0.0
 */
function yith_wacp_premium_install() {
	if ( ! function_exists( 'WC' ) ) {
		add_action( 'admin_notices', 'yith_wacp_premium_install_woocommerce_admin_notice' );
	} else {
		do_action( 'yith_wacp_premium_init' );
	}
}

add_action( 'plugins_loaded', 'yith_wacp_premium_install', 11 );
