<?php
/**
 * General options tab array
 *
 * @package YITH\AddedToCartPopup\PluginOptions
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

$general = array(
	'general-settings' => array(
		array(
			'title' => esc_html__( 'General Options', 'yith-woocommerce-added-to-cart-popup' ),
			'type'  => 'title',
			'desc'  => '',
			'id'    => 'yith-wacp-general-options',
		),
		array(
			'title'     => esc_html__( 'Show popup in', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'desc'      => esc_html__( 'Choose how to manage the Exclusion List: you can either show the popup on all products except for those that are in the Exclusion List or show it ONLY on the products that are in the Exclusion List.', 'yith-woocommerce-added-to-cart-popup' ),
			'default'   => yith_wacp_get_default( 'exclusion' ),
			'id'        => 'yith-wacp-exclusion',
			'options'   => array(
				'all-products'   => esc_html__( 'All products (except the ones in the Exclusion List)', 'yith-woocommerce-added-to-cart-popup' ),
				'exclusion-list' => esc_html__( 'Products in the Exclusion List only', 'yith-woocommerce-added-to-cart-popup' ),
			),
		),
		array(
			'title'     => esc_html__( 'Show popup on shop pages', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show the popup on the Shop page, category pages, shortcodes, etc.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'enable-on-archive' ),
			'id'        => 'yith-wacp-enable-on-archive',
		),
		array(
			'title'     => esc_html__( 'Show popup on product detail page', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show the popup on the product detail page.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'enable-on-single' ),
			'id'        => 'yith-wacp-enable-on-single',
		),
		array(
			'title'     => esc_html__( 'Show popup on mobile devices', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show the popup also on mobile devices.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'enable-on-mobile' ),
			'id'        => 'yith-wacp-enable-mobile',
		),
		array(
			'title'     => esc_html__( 'Popup content', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'default'   => yith_wacp_get_default( 'layout-popup' ),
			'id'        => 'yith-wacp-layout-popup',
			'desc'      => esc_html__( 'Choose what to show in the popup, either the full cart content or only the product added to the cart.', 'yith-woocommerce-added-to-cart-popup' ),
			'options'   => array(
				'cart'    => esc_html__( 'Full cart content', 'yith-woocommerce-added-to-cart-popup' ),
				'product' => esc_html__( 'Only the product added', 'yith-woocommerce-added-to-cart-popup' ),
			),
		),
		yith_wacp_is_ywraq_enabled() ? array(
			'title'     => esc_html__( 'Enable for "Request a Quote" button', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable the plugin features also for YITH WooCommerce Request A Quote.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'enable-raq' ),
			'id'        => 'yith-wacp-enable-raq',
		) : array(),
		yith_wacp_is_ywfbt_enabled() ? array(
			'title'     => esc_html__( 'Enable for "Frequently Bought Together" button', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable the plugin features also for YITH WooCommerce Frequently Bought Together Premium.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'enable-wfbt' ),
			'id'        => 'yith-wacp-enable-wfbt',
		) : array(),
		array(
			'type' => 'sectionend',
			'id'   => 'yith-wacp-general-options',
		),
	),
);

/**
 * APPLY_FILTERS: yith_wacp_panel_general_options
 *
 * Customize tab options.
 *
 * @param array $general Options array.
 */
return apply_filters( 'yith_wacp_panel_general_options', $general );
