<?php
/**
 * Popup cart info template
 *
 * @package YITH\AddedToCartPopup\Templates
 * @var $cart_shipping boolean Check if shipping should be displayed.
 * @var $cart_tax      boolean Check if taxes should be displayed.
 * @var $cart_total    boolean Check if cart totals should be displayed.
 * @var $cart_info     array The cart data to be displayed.
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

?>
<div class="yith-wacp-cart-info">
	<?php if ( $cart_shipping && isset( $cart_info['shipping'] ) ) : ?>
		<div class="cart-shipping">
			<?php
			/**
			 * APPLY_FILTERS: yith_wacp_shipping_label
			 *
			 * Handles the shipping label text.
			 *
			 * @param string $text The label text.
			 */
			echo esc_html( apply_filters( 'yith_wacp_shipping_label', esc_html__( 'Shipping', 'yith-woocommerce-added-to-cart-popup' ) ) ) . ':';
			?>
			<span class="cart-total-amount shipping-cost">
				<?php echo wp_kses_post( $cart_info['shipping'] ); ?>
			</span>
		</div>
	<?php endif; ?>
	<?php if ( $cart_tax && isset( $cart_info['tax'] ) ) : ?>
		<div class="cart-tax">
			<?php
			/**
			 * APPLY_FILTERS: yith_wacp_tax_label
			 *
			 * Handles the tax label text.
			 *
			 * @param string $text The label text.
			 */
			echo esc_html( apply_filters( 'yith_wacp_tax_label', esc_html__( 'Taxes', 'yith-woocommerce-added-to-cart-popup' ) ) ) . ':';
			?>
			<span class="cart-total-amount tax-cost">
				<?php echo wp_kses_post( empty( $cart_info['tax'] ) ? wc_price( 0 ) : $cart_info['tax'] ); ?>
			</span>
		</div>
	<?php endif; ?>
	<?php if ( $cart_total && isset( $cart_info['total'] ) ) : ?>
		<?php if ( ! empty( $cart_info['discount'] ) ) : ?>
			<div class="cart-discount">
				<?php
				/**
				 * APPLY_FILTERS: yith_wacp_discount_label
				 *
				 * Handles the discount label text.
				 *
				 * @param string $text The label text.
				 */
				echo esc_html( apply_filters( 'yith_wacp_discount_label', esc_html__( 'Discount', 'yith-woocommerce-added-to-cart-popup' ) ) ) . ':';
				?>
				<span class="cart-total-amount discount-cost">
					<?php echo wp_kses_post( $cart_info['discount'] ); ?>
				</span>
			</div>
		<?php endif; ?>
		<div class="cart-totals">
			<?php
			/**
			 * APPLY_FILTERS: yith_wacp_cart_total_label
			 *
			 * Handles the cart total label text.
			 *
			 * @param string $text The label text.
			 */
			echo esc_html( apply_filters( 'yith_wacp_cart_total_label', esc_html__( 'Cart Total', 'yith-woocommerce-added-to-cart-popup' ) ) ) . ':';
			?>
			<span class="cart-total-amount cart-cost">
				<?php echo wp_kses_post( apply_filters( 'woocommerce_cart_totals_order_total_html', $cart_info['total'] ) ); ?>
			</span>
		</div>
	<?php endif; ?>
</div>
