<?php
/**
 * YWBC_Elementor_Orders_Panel class
 *
 * @package YITH\Barcodes\Classes\Elementor
 */

use Elementor\Controls_Manager;
use Elementor\Widget_Button;
use ElementorPro\Modules\QueryControl\Module;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'YWBC_Elementor_Orders_Panel' ) ) {

	/**
	 * Class YWBC_Elementor_Orders_Panel
	 */
	class YWBC_Elementor_Orders_Panel extends \Elementor\Widget_Base {

		/**
		 * Get widget name.
		 */
		public function get_name() {
			return 'ywgc-orders-panel';
		}

		/**
		 * Get widget title.
		 */
		public function get_title() {
			return esc_html__( 'YITH Barcodes Orders Panel', 'yith-woocommerce-barcodes' );
		}

		/**
		 * Get widget icon.
		 */
		public function get_icon() {
			return 'eicon-product-info';
		}

		/**
		 * Get widget categories.
		 */
		public function get_categories() {
			return array( 'yith' );
		}

		/**
		 * Register widget controls.
		 */
		protected function register_controls() {

			$this->start_controls_section(
				'content_section',
				array(
					'label' => esc_html__( 'Content', 'yith-woocommerce-barcodes' ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
				)
			);

			$this->add_control(
				'section-description',
				array(
					'label'       => esc_html__( 'Form description', 'yith-woocommerce-barcodes' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'input_type'  => 'text',
					'placeholder' => esc_html__( 'Write a description here', 'yith-woocommerce-barcodes' ),
				)
			);

			$this->end_controls_section();
		}

		/**
		 * Render widget output on the frontend.
		 */
		protected function render() {
			$settings = $this->get_settings_for_display();

			$html = wp_oembed_get( $settings['section-description'] );

			echo '<style> .ywbc-shortcode-form {
							    text-align: center;
							    background-color: #f2f2f2;
							    padding: 50px 30px;
							    border-radius: 5px;
							    margin-left: auto;
							    margin-right: auto;
							    width: 50%;
							}
							
							.ywbc-shortcode-form-title{
							    text-transform: uppercase;
							    margin: 0;
							    font-size: 15px;
							    text-align: left;
							    margin-left: 10%;
							    margin-bottom: 10px;
							}
							
							.ywbc-shortcode-form-label{
							    display: block;
							    font-weight: bold;
							    text-align: left;
							    margin-left: 10%;
							}
							
							.ywbc-shortcode-text-input{
							    margin: 10px 0;
							    width: 80%;
							}
				</style>';

			echo '<div class="ywgc-orders-panel-elementor-widget">';

			echo wp_kses_post( $html ? $html : $settings['section-description'] );

			echo do_shortcode( '[yith_order_barcode]' );

			echo '</div>';
		}

	}
}
