<?php
/**
 * YWBC_Elementor class
 *
 * @package YITH\Barcodes\Classes\Elementor
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Implements the YWBC_Elementor class.
 *
 * @class   YWBC_Elementor
 * @package YITH
 * @since   2.0.0
 * @author  YITH <plugins@yithemes.com>
 */
if ( ! class_exists( 'YWBC_Elementor' ) ) {

	/**
	 * Class YWBC_Elementor
	 */
	class YWBC_Elementor {
		/**
		 * Single instance of the class
		 *
		 * @var YWBC_Elementor
		 */

		protected static $instance;

		/**
		 * Store the order to use in widget previews
		 *
		 * @var int
		 */
		public $order_to_test = 0;

		/**
		 * Returns single instance of the class
		 *
		 * @return YWBC_Elementor
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 * YWBC_Elementor constructor.
		 */
		public function __construct() {
			if ( did_action( 'elementor/loaded' ) ) {
				add_action( 'elementor/elements/categories_registered', array( $this, 'add_elementor_yith_widget_category' ) );

				$register_widget_hook = version_compare( ELEMENTOR_VERSION, '3.5.0', '>=' ) ? 'elementor/widgets/register' : 'elementor/widgets/widgets_registered';
				// register widgets.
				add_action( $register_widget_hook, array( $this, 'elementor_init_widgets' ) );
			}
		}

		/**
		 * Load frontend styles
		 */
		public function load_frontend_styles() {

		}

		/**
		 * Add YITH category
		 *
		 * @param object $elements_manager .
		 */
		public function add_elementor_yith_widget_category( $elements_manager ) {
			$elements_manager->add_category(
				'yith',
				array(
					'title' => 'YITH',
					'icon'  => 'fa fa-plug',
				)
			);

		}

		/**
		 * Init Widget
		 *
		 * @throws Exception .
		 */
		public function elementor_init_widgets() {

			// Include Widget files.
			require_once YITH_YWBC_DIR . 'includes/third-party/elementor/class-ywbc-elementor-products-panel.php';
			require_once YITH_YWBC_DIR . 'includes/third-party/elementor/class-ywbc-elementor-orders-panel.php';
			require_once YITH_YWBC_DIR . 'includes/third-party/elementor/class-ywbc-elementor-render-barcode.php';
			require_once YITH_YWBC_DIR . 'includes/third-party/elementor/class-ywbc-elementor-render-actual-post-barcode.php';

			// Register widget.
			$widgets_manager = \Elementor\Plugin::instance()->widgets_manager;
			if ( is_callable( array( $widgets_manager, 'register' ) ) ) {
				$widgets_manager->register( new \YWBC_Elementor_Products_Panel() );
				$widgets_manager->register( new \YWBC_Elementor_Orders_Panel() );
				$widgets_manager->register( new \YWBC_Elementor_Render_Barcode() );
				$widgets_manager->register( new \YWBC_Elementor_Render_Actual_Post_Barcode() );
			} else {
				$widgets_manager->register_widget_type( new \YWBC_Elementor_Products_Panel() );
				$widgets_manager->register_widget_type( new \YWBC_Elementor_Orders_Panel() );
				$widgets_manager->register_widget_type( new \YWBC_Elementor_Render_Barcode() );
				$widgets_manager->register_widget_type( new \YWBC_Elementor_Render_Actual_Post_Barcode() );
			}
		}
	}
}

/**
 * Unique access to instance of YWBC_Elementor class
 *
 * @return YWBC_Elementor
 */
function ywbc_elementor() {
	return YWBC_Elementor::get_instance();
}

ywbc_elementor();
