<?php
/**
 * This file belongs to the YIT Plugin Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package YITH\Barcodes\PluginOptions
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


$tool = array(

	'settings-print' => array(

		'tool_section_start'                         => array(
			'name' => __( 'Print configuration', 'yith-woocommerce-barcodes' ),
			'type' => 'title',
		),

		'tool_print_barcodes_show_image'             => array(
			'name'          => __( 'In the printable list show', 'yith-woocommerce-barcodes' ),
			'type'          => 'checkbox',
			'checkboxgroup' => 'start',
			'desc'          => __( 'Product image', 'yith-woocommerce-barcodes' ),
			'id'            => 'tool_print_barcodes_show_image',
			'default'       => 'no',
		),
		'tool_print_barcodes_show_name'              => array(
			'name'          => __( 'Show product name', 'yith-woocommerce-barcodes' ),
			'type'          => 'checkbox',
			'checkboxgroup' => 'print_barcode_info',
			'desc'          => __( 'Product name', 'yith-woocommerce-barcodes' ),
			'id'            => 'tool_print_barcodes_show_name',
			'default'       => 'yes',
		),
		'tool_print_barcodes_show_price'             => array(
			'name'          => __( 'Show product price', 'yith-woocommerce-barcodes' ),
			'type'          => 'checkbox',
			'checkboxgroup' => 'print_barcode_info',
			'desc'          => __( 'Product price', 'yith-woocommerce-barcodes' ),
			'id'            => 'tool_print_barcodes_show_price',
			'default'       => 'no',
		),
		'tool_print_barcodes_show_sku'               => array(
			'name'          => __( 'Show product SKU', 'yith-woocommerce-barcodes' ),
			'type'          => 'checkbox',
			'checkboxgroup' => 'print_barcode_info',
			'desc'          => __( 'Product SKU', 'yith-woocommerce-barcodes' ),
			'id'            => 'tool_print_barcodes_show_sku',
			'default'       => 'yes',
		),
		'tool_print_barcodes_show_short_description' => array(
			'name'          => __( 'Show product short description', 'yith-woocommerce-barcodes' ),
			'type'          => 'checkbox',
			'checkboxgroup' => 'end',
			'desc'          => __( 'Product short description', 'yith-woocommerce-barcodes' ),
			'id'            => 'tool_print_barcodes_show_short_description',
			'default'       => 'no',
		),
		'tool_print_barcodes_number_of_columns'      => array(
			'name'      => __( 'Number of columns', 'yith-woocommerce-barcodes' ),
			'type'      => 'yith-field',
			'yith-type' => 'number',
			'desc'      => __( 'Choose the number of columns to display in the printable list', 'yith-woocommerce-barcodes' ),
			'id'        => 'tool_print_barcodes_number_of_columns',
			'default'   => '2',
		),
		'ywbc_enable_print_barcodes_variations'      => array(
			'name'      => __( 'Print a barcode list of: ', 'yith-woocommerce-barcodes' ),
			'type'      => 'yith-field',
			'yith-type' => 'select',
			'id'        => 'ywbc_enable_print_barcodes_variations',
			'options'   => array(
				'all_products'       => __( 'All products', 'yith-woocommerce-barcodes' ),
				'include_variations' => __( 'All products, including variations', 'yith-woocommerce-barcodes' ),
				'all_stock'          => __( 'All products by stock', 'yith-woocommerce-barcodes' ),
			),
			'default'   => 'all_products',
		),
		'tool_print_barcodes'                        => array(
			'type' => 'print-barcodes',
			'desc' => __( 'Choose to print a list of barcodes of all products and if include or not the products variations', 'yith-woocommerce-barcodes' ),
			'id'   => 'ywbc_print_product_barcode',
		),
		'tool_print_barcodes_by_products'            => array(
			'name' => __( 'Print barcodes by product', 'yith-woocommerce-barcodes' ),
			'type' => 'print-barcodes-by-products',
			'id'   => 'tool_print_barcodes_by_products',
		),

		'tool_print_section_end'                     => array(
			'type' => 'sectionend',
		),

	),
);

/** APPLY_FILTERS: ywbc_tool_otions
*
* Filter the default plugin tools options.
*/
return apply_filters( 'ywbc_tool_otions', $tool );
