<?php
/**
 * Template to display the barcodes printing settings
 *
 * @package YITH\Barcodes\Templates\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$name          = isset( $option['name'] ) ? $option['name'] : '';

$print_all_url = esc_url( add_query_arg( array( 'action' => 'print_all_barcodes' ), admin_url( 'admin.php' ) ) );
$pdf_button_text = __( 'Download PDF', 'yith-woocommerce-barcodes' );


$option_action = isset( $option['action'] ) ? $option['action'] : 'print_product_barcodes_pdf';
$name          = isset( $option['name'] ) ? $option['name'] : '';


?>

	<tr valign="top" class="ywbc-print-barcode-tr">
		<th scope="row" class="titledesc"><?php esc_attr( $name ); ?></th>

		<td class="forminp">
			<div class="yith-plugin-fw__panel__option__content" style="margin-bottom: 10px;">
				<?php echo sprintf( '<a class="button button-primary export ywbc-print-button" href="%s" title="%2$s">' . $pdf_button_text . '</a>', $print_all_url, $pdf_button_text );   ?>
				<input type="button" class="button button-primary ywbc-print-barcode"
				       data-barcode_action="<?php esc_attr( $option_action ); ?>"
				       value="<?php echo sprintf( esc_html__( 'Print', 'yith-woocommerce-barcodes' ) ); ?>">
			</div>

			<div class="yith-plugin-fw__panel__option__description"><?php echo esc_html( $desc ); ?></div>
		</td>

	</tr>

<div id="aux-print-barcodes"></div>
