<?php
/**
 * Template to print the barcode actions
 *
 * @package YITH\Barcodes\Templates\Shortcode
 */

$user = wp_get_current_user();

if ( ! apply_filters( 'ywbc_force_shortcode_display', false ) && isset( $fields['capability'] ) && ! count( array_intersect( (array) $fields['capability'], (array) $user->roles ) ) ) {
	return;
}

$actions = $fields['actions'];

if ( ! $actions ) {
	return;
}


?>
<div class="yith-barcode-actions">
	<form class="ywbc-shortcode-form" name="yith-barcodes-form" method="post" data-barcode-type="<?php echo esc_attr( $fields['search_type'] ); ?>" data-barcode-actions='<?php echo esc_attr( wp_json_encode( $actions ) ); ?>'>
		<?php
		if ( 'product' === $fields['search_type'] && function_exists( 'yith_pos_get_stores' ) ) {

			$store_ids   = yith_pos_get_stores();
			$store_names = array_map( 'yith_pos_get_register_name', $store_ids );
			$stores      = array_combine( $store_ids, $store_names );

			echo "<div class='select-store-id-container'>";
			echo "<select name='barcode-actions-store-id' id='barcode-actions-store-id'>";
			echo "<option value=''>" . esc_html__( 'Select a store', 'yith-point-of-sale-for-woocommerce' ) . '</option>';
			foreach ( $stores as $id => $name ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride
				echo '<option value="' . esc_attr( $id ) . '">' . esc_html( $name ) . '</option>';
			}
			echo '</select></div>';

		}
		?>
		<p class="ywbc-shortcode-form-title"><?php echo esc_html( $title ); ?></p>
		<label class="ywbc-shortcode-form-label"><?php echo esc_html_x( 'Type or scan the barcode value here', 'placeholder for barcode text field', 'yith-woocommerce-barcodes' ); ?></label>
		<input class="ywbc-shortcode-text-input" type="text" name="yith-barcode-value" value="" autofocus>
	</form>
</div>
