<?php
/**
 * Template to search products
 *
 * @package YITH\Barcodes\Templates\Shortcode
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( $posts ) : ?>
	<table class="shop_table shop_table_responsive ywbc-search-by-orders ywbc-shortcode-table">
		<thead>
		<tr class="ywbc-search-order-row-title">

			<th class="ywbc-order-number">
				<span class="nobr"><?php echo esc_html__( 'Order', 'yith-woocommerce-barcodes' ); ?></span>
			</th>

			<th class="ywbc-order-date">
				<span class="nobr"><?php echo esc_html__( 'Date', 'yith-woocommerce-barcodes' ); ?></span>
			</th>

			<th class="ywbc-order-customer">
				<span class="nobr"><?php echo esc_html__( 'Customer', 'yith-woocommerce-barcodes' ); ?></span>
			</th>

			<th class="ywbc-order-purchased-products">
				<span class="nobr"><?php echo esc_html__( 'Products', 'yith-woocommerce-barcodes' ); ?></span>
			</th>

			<th class="ywbc-order-total">
				<span class="nobr"><?php echo esc_html__( 'Total', 'yith-woocommerce-barcodes' ); ?></span>
			</th>

			<?php if ( defined( 'YITH_WCBK_INIT' ) ) { ?>
			<th class="ywbc-booking-info">
				<span class="nobr"><?php echo esc_html__( 'Booking info', 'yith-woocommerce-barcodes' ); ?></span>
			</th>
			<?php } ?>

			<th class="ywbc-barcode-value">
				<span class="nobr"><?php echo esc_html__( 'Barcode', 'yith-woocommerce-barcodes' ); ?></span>
			</th>

			<th class="ywbc-order-status">
				<span class="nobr"><?php echo esc_html__( 'Status', 'yith-woocommerce-barcodes' ); ?></span>
			</th>

			<?php if ( ! empty( $barcode_actions ) ) { ?>
			<th class="ywbc-barcode-action">
			</th>
			<?php } ?>

		</tr>
		</thead>

		<tbody>
		<?php
		foreach ( $posts as $post_object ) {
			$order_object = wc_get_order( $post_object );
			if ( $order_object ) {
				wc_get_template(
					'shortcode/ywbc-search-orders-row.php',
					array(
						'object'          => $order_object,
						'barcode_actions' => $barcode_actions,
					),
					'',
					YITH_YWBC_TEMPLATES_DIR
				);
			}
		}
		?>
		</tbody>
	</table>

	<?php if ( ! empty( $barcode_actions ) ) { ?>
		<div class="ywbc-shortcode-actions-container">
			<?php foreach ( $barcode_actions as $barcode_action_key => $barcode_action ) : ?>

			<?php

				$order_object = wc_get_order( $post_object );
				$order_status = $order_object->get_status();
				$order_id     = $order_object->get_id();

				if ( $order_status === $barcode_action_key ){
					continue;
				}
				?>
			<div class="ywbc-shortcode-actions-div">
				<button class="ywbc-action btn btn-primary"
				        data-status="<?php echo esc_attr( sanitize_title_for_query( strtolower( $barcode_action_key ) ) ); ?>"
				        data-type="order"
				        data-id="<?php echo esc_attr( $order_id ); ?>"
					<?php echo ( $order_status === $barcode_action_key ) ? 'disabled' : ''; ?>>
					<?php echo wp_kses_post( $barcode_action ); ?>
				</button>
			</div>
			<?php endforeach; ?>
		</div>

	<?php } ?>


<?php else : ?>
	<span><?php esc_html_e( 'No order matches the selected criteria', 'yith-woocommerce-barcodes' ); ?></span>
	<?php
endif;
