<?php
/**
 * Template to print products in the frontend
 *
 * @package YITH\Barcodes\Templates\Shortcode
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! is_object( $object ) ) {
	return;
}

$product_id     = $object->get_id();
$product        = wc_get_product( $product_id );

?>
<tr class="ywbc-search-row">
	<td class="ywbc-product-name" valign="top" >
		<div class="ywgc-shortcode-product-image-name-container">
			<div class="ywgc-shortcode-product-image"><?php echo wp_kses_post( $product->get_image( array(50, 50) ) ); ?></div>
			<div class="ywgc-shortcode-product-name">
				<p><a href="<?php echo esc_url( $product->get_permalink() ); ?>"><?php echo wp_kses_post( $product->get_name() ) . ' '; ?></a></p>
			</div>
		</div>
	</td>

	<td class="ywbc-product-price" valign="top" >
		<div class="ywgc-shortcode-product-price">
			<p>
				<?php echo $product->get_price_html(); ?>
			</p>
		</div>
	</td>

	<td class="ywbc-product-barcode" valign="top">
		<?php
		$barcode_instance = YITH_Barcode::get( $product_id );
		echo wp_kses_post( YITH_YWBC()->render_barcode( $barcode_instance ) );
		echo "<div class='ywbc-search-product-barcode-value'>" . wp_kses_post( $barcode_instance->get_display_value() ) . '</div>';
		?>
	</td>

	<td class="ywbc-product-actions" valign="top">
		<?php if ( $product->managing_stock() && 'yes' === get_option( 'ywbc_product_shortcode_stock_buttons', 'yes' ) ) : ?>

		<div class="ywbc-stock-manage-container">

			<div class="ywbc-stock-buttons-actions-div minus">
				<button class="ywbc-action btn btn-primary"
				        data-status="decrease-stock"
				        data-id="<?php echo esc_attr( $product_id ); ?>"
				        data-type="product">
					<?php
					echo '<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
  <path stroke-linecap="round" stroke-linejoin="round" d="M15 12H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
</svg>
'; ?>
				</button>
			</div>

				<div class="ywbc-stock-input-container">
					<input id="ywbc-stock-unit" data-id="<?php echo esc_attr( $product_id ); ?>" class="btn" type="number" min="0" value="<?php echo $product->get_stock_quantity() ?>">
				</div>

			<div class="ywbc-stock-buttons-actions-div plus">
				<button class="ywbc-action btn btn-primary"
				        data-status="increase-stock"
				        data-id="<?php echo esc_attr( $product_id ); ?>"
				        data-type="product">
					<?php
					echo '<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
  <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v6m3-3H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
</svg>
'; ?>
				</button>
			</div>
		</div>

		<?php elseif ( $product->managing_stock() && 'no' === get_option( 'ywbc_product_shortcode_stock_buttons', 'yes' ) ) : ?>
			<p><?php echo $product->get_stock_quantity(); ?></p>

		<?php elseif ( ! $product->managing_stock() ) : ?>
			<p><?php echo esc_html__( 'Stock disabled', 'yith-woocommerce-barcodes' ); ?></p>
		<?php endif; ?>
	</td>
</tr>
