jQuery(function ($) {
  $(document).on('click', '.ywbc_apply_barcode', function (e) {
    e.preventDefault();

    var item_ids = $(this).data('item_ids'),
      ajax_action = $(this).data('barcode_action'),
      progress_bar = $('#ywbc_apply_progressbar_all'),
      progress_bar_perc = $('#ywbc_apply_progressbar_percent_all'),
      message_container = $('.ywbc_apply_messages'),
      current_index = 0,
      mode_option = $(this).parent().parent().parent().find( "[data-dep-target='ywbc_tool_regenerate_barcodes'] " ),
      mode = mode_option.find( '#ywbc_tool_regenerate_barcodes').val();

    message_container.hide();

    //initialize progressbar
    progress_bar.progressbar();
    progress_bar_perc.html("0% (0/" + item_ids.length + ")");
    progress_bar.show();

    var item_length = item_ids.length;

    $(this).prop('disabled', true);

    function applyBarcode(current_index, item_id) {

      var data = {
        ywbc_item_id: item_id,
        mode: mode,
        action: ajax_action
      };

      $.ajax({

        type: 'POST',
        url: ywbc_params.ajax_url,
        data: data,
        dataType: 'json',
        success: function (response) {

          if (response.result == 'barcode_created') {

            progress_bar.progressbar("value", ( (current_index + 1) / item_length ) * 100);
            progress_bar_perc.html(Math.round(( (current_index + 1) / item_length ) * 1000) / 10 + "%" +  " (" + (current_index + 1) + "/" + item_ids.length + ")");

            if (current_index < item_length - 1) {
              current_index++;
              applyBarcode(current_index, item_ids[current_index]);
            } else {
              message_container.addClass('complete_all_task');
              message_container.find('.ywbc_apply_icon').addClass('dashicons dashicons-yes');
              message_container.find('.ywbc_apply_icon').css( 'color', 'green' );
              message_container.find('.ywbc_apply_text').css( 'color', 'green' );
              message_container.find('.ywbc_apply_text').html(ywbc_params.messages.complete_task);
              message_container.show();
              progress_bar.hide();
              $('.ywbc_apply_barcode').prop('disabled', false);
            }

          }
          else if ( response.result == 'barcode_wrong_format' ){

            message_container.addClass('error_task');
            message_container.find('.ywbc_apply_icon').addClass('dashicons dashicons-no');
            message_container.find('.ywbc_apply_icon').css( 'color', 'red' );
            message_container.find('.ywbc_apply_text').css( 'color', 'red' );
            message_container.find('.ywbc_apply_text').html(ywbc_params.messages.completed_with_errors);
            $( "<br><code class='ywbc_error_information'></code><p class='ywbc_after_error_information'></p>" ).insertAfter( message_container.find('.ywbc_apply_text') ).text( response.error_message );
            message_container.find('.ywbc_after_error_information').html(ywbc_params.messages.link_to_protocols);

            message_container.show();
            progress_bar.hide();
            $('.ywbc_apply_barcode').prop('disabled', false);

          }
          else {
            message_container.addClass('error_task');
            message_container.find('.ywbc_apply_icon').addClass('dashicons dashicons-no');
            message_container.find('.ywbc_apply_icon').css( 'color', 'red' );
            message_container.find('.ywbc_apply_text').html(ywbc_params.messages.error_task);
            message_container.show();
            progress_bar.hide();
            $('.ywbc_apply_barcode').prop('disabled', false);
          }

        },

      });
    }

    applyBarcode(current_index, item_ids[current_index]);

  });

  $(document).on('yith-plugin-fw-float-save-button-after-saving', function( event, response ) {

    var  message_container = $('.ywbc_apply_messages');
    message_container.empty();
    message_container.removeClass('error_task');
    message_container.html( '<span class="ywbc_apply_icon"></span>' + '<span class="ywbc_apply_text"></span>');

  });


  $(document).on('change', '#ywbc_tool_regenerate_barcodes', function (e) {
    window.onbeforeunload = null;
    e.preventDefault();

    var mode = $(this).val();

    var block_zone = $( this ).parent();

    block_zone.block({message: null, overlayCSS: {background: "#f1f1f1", opacity: .7}});

    var data = {
      action: 'regenerate_barcodes_selector_change',
      mode: mode,
    };

    $.ajax({
      type: 'POST',
      url: ywbc_params.ajax_url,
      data: data,
      success: function (response) {
        document.location.reload();
        block_zone.unblock();

      },
      error: function (response) {
        block_zone.unblock();
        console.log("ERROR");
        console.log(response);
      }

    });

  });



  $(document).on('change', '#ywbc_enable_print_barcodes_variations', function (e) {
    e.preventDefault();

    var mode = $(this).val();

    var block_zone = $( this ).parent();

    block_zone.block({message: null, overlayCSS: {background: "#f1f1f1", opacity: .7}});

    var data = {
      action: 'print_barcodes_selector_change',
      mode: mode,
    };

    $.ajax({
      type: 'POST',
      url: ywbc_params.ajax_url,
      data: data,
      success: function (response) {
        document.location.reload();
        block_zone.unblock();

      },
      error: function (response) {
        block_zone.unblock();
        console.log("ERROR");
        console.log(response);
      }

    });

  });

  //print barcodes by product
  $(document).on('change', 'select#print_barcodes_by_product_select', function (e) {

    var product_id = $('#print_barcodes_by_product_select option:last-child').val();
    var product_quantity = $('.ywbc-print-barcode-by-product-quantity').val();

    if ( product_quantity == null ){
      product_quantity = 1;
    }

    var href =   $( 'a.ywbc-print-barcode-by-product' ).data( "href-aux" );

    $( 'a.ywbc-print-barcode-by-product' ).attr("href", href + '&product_id='+product_id+'&product_quantity='+product_quantity+'');

  });

  $(document).on('change', 'input.ywbc-print-barcode-by-product-quantity', function (e) {

    var product_id = $('#print_barcodes_by_product_select option:last-child').val();
    var product_quantity = $('.ywbc-print-barcode-by-product-quantity').val();

    if ( product_quantity == null ){
      product_quantity = 1;
    }

    var href =   $( 'a.ywbc-print-barcode-by-product' ).data( "href-aux" );

    $( 'a.ywbc-print-barcode-by-product' ).attr("href", href + '&product_id='+product_id+'&product_quantity='+product_quantity+'');

  });

  $(document).on('click', '.print_barcodes_by_product_select', function (e) {

    var product_id = $(this).parent().find('#print_barcodes_by_product_select option:last-child').val();

    if ( product_id == null ){
      alert('Select a product');
      return;
    }
  });

  $(document).on('click', '.ywbc-print-barcode-by-product', function (e) {

    var product_id = $('#print_barcodes_by_product_select option:last-child').val();

    if ( product_id == null ){
      e.preventDefault();
      alert('Select a product');
      return;
    }

  });

  // Browser print ---------------

  //print all product barcodes
  $(document).on('click', '.ywbc-print-barcode', function (e) {
    e.preventDefault();

    var ajax_zone = $('.ywbc-print-barcode-tr');

    var data = {
      action: 'print_barcodes_in_browser',
    };

    ajax_zone.block({message: null, overlayCSS: {background: "#f1f1f1", opacity: .7}});

    $.ajax({
      type: 'POST',
      url: ywbc_params.ajax_url,
      data: data,
      success: function (response) {
        console.log('Processing, do not cancel');

        $('#aux-print-barcodes').append(response['result']);

        var divToPrint=document.getElementById("aux-print-barcodes");
        newWin= window.open("about:blank");
        newWin.document.write(divToPrint.outerHTML);

        setTimeout(function () { // wait until all resources loaded
          newWin.print();  // change window to winPrint
          newWin.close();// change window to winPrint
        }, 200);

        $('#aux-print-barcodes').html("");
        ajax_zone.unblock();
      },
      error: function (response) {
        console.log("ERROR");
        console.log(response);
        ajax_zone.unblock();
        return false;
      }
    });
  });



  //print barcodes by product
  $(document).on('click', '.ywbc-print-barcode-by-product-browser', function (e) {
    e.preventDefault();

    // var product_id = $(this).parent().find('.print-by-products-container .ywbc-print-barcode-by-product-id #print_barcodes_by_product_select option:last-child').val();
    var product_id = $('#print_barcodes_by_product_select option:last-child').val();
    var product_quantity = $('.ywbc-print-barcode-by-product-quantity').val();

    if ( product_id == null ){
      alert('Select a product');
      return;
    }

    if ( product_quantity == '' ){
      product_quantity = 1;
    }

    var ajax_zone = $('.ywbc-print-barcode-by-product-buttons-tr');

    var data = {
      action: 'print_barcodes_by_product_browser',
      ywbc_product_id: product_id,
      ywbc_product_quantity: product_quantity,
    };

    ajax_zone.block({message: null, overlayCSS: {background: "#f1f1f1", opacity: .7}});

    $.ajax({
      type: 'POST',
      url: ywbc_params.ajax_url,
      data: data,
      success: function (response) {
        console.log('Processing, do not cancel');

        $('#aux-print-barcodes-by-products').append(response['result']);

        var divToPrint=document.getElementById("aux-print-barcodes-by-products");
        newWin= window.open("about:blank");
        newWin.document.write(divToPrint.outerHTML);

        setTimeout(function () { // wait until all resources loaded
          newWin.print();  // change window to winPrint
          newWin.close();// change window to winPrint
        }, 200);

        $('#aux-print-barcodes-by-products').html("");
        ajax_zone.unblock();
      },
      error: function (response) {
        console.log("ERROR");
        console.log(response);
        ajax_zone.unblock();
        return false;
      }
    });
  });


});

