<?php
/**
 * Settings options
 *
 * @package YITH\GiftCards\PluginOptions
 */

defined( 'ABSPATH' ) || exit();

$sub_tabs = array(
	'settings-product'            => array(
		'title'              => _x( 'Product barcodes', 'Tab title in plugin settings panel', 'yith-woocommerce-barcodes' ),
		'yith-ywgc-priority' => 20,
		'description'        => _x( 'Configure the barcodes for your products.', 'Tab description in plugin settings panel', 'yith-woocommerce-barcodes' ),
	),
	'settings-order'             => array(
		'title'              => _x( 'Order barcodes', 'Tab title in plugin settings panel', 'yith-woocommerce-barcodes' ),
		'yith-ywgc-priority' => 20,
		'description'        => _x( 'Configure the barcodes for your orders.', 'Tab description in plugin settings panel', 'yith-woocommerce-barcodes' ),
	),
	'settings-print' => array(
		'title'              => _x( 'Print barcodes', 'Tab title in plugin settings panel', 'yith-woocommerce-barcodes' ),
		'yith-ywgc-priority' => 20,
		'description'        => _x( 'Print your product barcodes.', 'Tab description in plugin settings panel', 'yith-woocommerce-barcodes' ),
	),
	'settings-shortcode'      => array(
		'title'              => _x( 'Shortcodes', 'Tab title in plugin settings panel', 'yith-woocommerce-barcodes' ),
		'yith-ywgc-priority' => 20,
		'description'        => _x( 'Configure the plugin shortcodes.', 'Tab description in plugin settings panel', 'yith-woocommerce-barcodes' ),
	),
);

$sub_tabs = apply_filters( 'yith_ywgc_panel_settings_sub_tabs', $sub_tabs );

$options = array(
	'settings' => array(
		'settings-tabs' => array(
			'type'     => 'multi_tab',
			'sub-tabs' => $sub_tabs,
		),
	),
);

return apply_filters( 'yith_ywgc_panel_settings_options', $options );
