<?php
/**
 * Template to search products
 *
 * @package YITH\Barcodes\Templates\Shortcode
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( $posts ) : ?>
	<table class="shop_table shop_table_responsive ywbc-search-by-products ywbc-shortcode-table">
		<thead>
		<tr class="ywbc-search-product-row-title">
			<th class="ywbc-product-title">
				<span class="nobr"><?php echo esc_html__( 'Product', 'yith-woocommerce-barcodes' ); ?></span>
			</th>

			<th class="ywbc-product-price">
				<span class="nobr"><?php echo esc_html__( 'Price', 'yith-woocommerce-barcodes' ); ?></span>
			</th>

			<th class="ywbc-barcode-value">
				<span class="nobr"><?php echo esc_html__( 'Barcode', 'yith-woocommerce-barcodes' ); ?></span>
			</th>

			<th class="ywbc-barcode-status">
				<span class="nobr"><?php echo esc_html__( 'Stock', 'yith-woocommerce-barcodes' ); ?></span>
			</th>
		</tr>
		</thead>

		<tbody>
		<?php
		foreach ( $posts as $post_object ) {
			$product = wc_get_product( $post_object );
			if ( $product ) {
				wc_get_template(
					'shortcode/ywbc-search-products-row.php',
					array(
						'object'          => $product,
						'barcode_actions' => $barcode_actions,
					),
					'',
					YITH_YWBC_TEMPLATES_DIR
				);
			}
		}
		?>
		</tbody>
	</table>

	<?php if ( 'yes' === get_option( 'ywbc_product_shortcode_add_to_cart', 'no' ) ) : ?>

		<?php
		if ( ! is_object( $post_object ) ){
			return;
		}
		?>

	<div class="ywbc-shortcode-actions-container">
		<div class="ywbc-shortcode-actions-div">
			<button class="ywbc-action btn btn-primary"
			        data-status="add-to-cart"
			        data-id="<?php echo esc_attr( $post_object->ID ); ?>"
			        data-type="product">
				<?php

				/** APPLY_FILTERS: ywbc_barcode_actions_name_filter
				 *
				 * Filter the name of the buttons of the shortcode table to be translated.
				 *
				 * @param $barcode_action Default actions.
				 */
				echo wp_kses_post( apply_filters( 'ywbc_barcode_add_to_cart_button_text', esc_html__( 'Add to cart', 'yith-woocommerce-barcodes' ) ) );
				?>
			</button>
		</div>
	</div>
	<?php endif; ?>
<?php else : ?>
	<span><?php esc_html_e( 'No product matches the selected criteria', 'yith-woocommerce-barcodes' ); ?></span>
	<?php
endif;
