<?php
/**
 * Template to display the barcodes printing settings for a specific product
 *
 * @package YITH\Barcodes\Templates\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$print_all_url = esc_url( add_query_arg( array( 'action' => 'print_barcodes_by_product' ), admin_url( 'admin.php' ) ) );
$button_text = __( 'Download PDF', 'yith-woocommerce-barcodes' );

$option_action = isset( $option['action'] ) ? $option['action'] : 'print_barcodes_by_product_pdf';



?>
<tr valign="top" class="ywbc-print-barcode-by-product-tr">
	<th scope="row" class="titledesc"><?php echo esc_html( $name ); ?></th>

	<td class="forminp ywbc-print-barcode-by-product-id-column">

		<div class="print-by-products-container">

		<p style="display: inline"><?php echo esc_html__( 'Print a document with ', 'yith-woocommerce-barcodes' ); ?></p>
		<input type="number" value="1" class="ywbc-print-barcode-by-product-quantity" style="width: 5%; margin: -10px 5px 0 5px;" min="1" placeholder="<?php echo esc_html__( 'Quantity', 'yith-woocommerce-barcodes' ); ?>">
		<p style="display: inline"><?php echo esc_html__( 'barcodes of this product: ', 'yith-woocommerce-barcodes' ); ?></p>

		<?php
		yith_plugin_fw_get_field(
			array(
				'id'   => 'print_barcodes_by_product_select',
				'type' => 'ajax-products',
				'data' => array(
					'action'   => 'woocommerce_json_search_products_and_variations',
					'security' => wp_create_nonce( 'search-products' ),
				),
			),
			true
		)
		?>

	</td>
</tr>

<tr valign="top" class="ywbc-print-barcode-by-product-buttons-tr">
	<th scope="row" class="titledesc"><?php esc_attr( $name ); ?></th>

	<td class="forminp">
		<div class="yith-plugin-fw__panel__option__content" style="margin-bottom: 10px;">
			<?php echo sprintf( '<a class="button button-primary export ywbc-print-button ywbc-print-barcode-by-product" data-href-aux="%s" href="%s" >' . $button_text . '</a>', $print_all_url, $print_all_url );   ?>

			<input type="button" class="button button-primary ywbc-print-barcode-by-product-browser"
			       data-barcode_action="<?php esc_attr( $option_action ); ?>"
			       value="<?php echo sprintf( esc_html__( 'Print', 'yith-woocommerce-barcodes' ) ); ?>">
		</div>

		<div class="yith-plugin-fw__panel__option__description"><?php echo esc_html__( 'Choose which product barcode print and how many of them', 'yith-woocommerce-barcodes' ); ?></div>
	</td>

</tr>

<div id="aux-print-barcodes-by-products"></div>
