<?php
/**
 * Template to print orders in the frontend
 *
 * @package YITH\Barcodes\Templates\Shortcode
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$order_id     = yit_get_prop( $object, 'id' );
$item_count   = $object->get_item_count();
$order_date   = yit_get_prop( $object, 'order_date' );
$order_status = $object->get_status();
?>
<tr class="ywbc-search-row">
	<td class="ywbc-order-number" valign="top">
		<?php
		printf(
			'%1$s',
			'<a href="' . esc_url( admin_url( 'post.php?post=' . absint( $order_id ) . '&action=edit' ) ) . '" class="row-title"><strong>#' . wp_kses_post( $object->get_order_number() ) . '</strong></a>' );
		?>
	</td>

	<td class="ywbc-order-date" valign="top">
		<?php
		echo wp_kses_post( date_i18n( get_option( 'date_format' ), strtotime( $order_date ) ) );
        ?>
	</td>

	<td class="ywbc-order-customer" valign="top">
		<?php
		// Order title.
		if ( $object->get_customer_id() ) {
			$user              = get_user_by( 'id', $object->get_customer_id() );
			$user_display_name = is_object( $user ) ? $user->display_name : '';
			$username          = '<a href="' . esc_url( admin_url( 'user-edit.php?user_id=' . absint( $object->get_customer_id() ) ) ) . '">';
			$username         .= esc_html( ucwords( $user_display_name ) );
			$username         .= '</a>';
		} elseif ( $object->get_billing_first_name() || $object->get_billing_last_name() ) {
			/* translators: 1: first name 2: last name */
			$username = trim( sprintf( esc_html_x( '%1$s %2$s', 'full name', 'yith-woocommerce-barcodes' ), $object->get_billing_first_name(), $object->get_billing_last_name() ) );
		} elseif ( $object->get_billing_company() ) {
			$username = trim( $object->get_billing_company() );
		} else {
			$username = esc_html__( 'Guest', 'yith-woocommerce-barcodes' );
		}

		echo wp_kses_post( $username );
		 ?>
	</td>

	<td class="ywbc-order-purchased-products" valign="top">
		<?php

		$order_object   = wc_get_order( $order_id );
		$product_names  = array();
		$product_images = array();

		foreach ( $order_object->get_items() as $item ) {
			$product_name     = $item->get_name();
			$product_quantity = $item->get_quantity();
			$product          = wc_get_product( $item->get_product_id() );
			$product_names[]  = $product_quantity . ' x ' . $product_name;
		}
		$cnt = 0;
		foreach ( $product_names as $product_name ) {
			?>
			<div class="ywgc-shortcode-product-image-name-container">
				<div class="ywgc-shortcode-product-image"><?php echo wp_kses_post( $product->get_image( array(50, 50) ) ); ?></div>
				<div class="ywgc-shortcode-product-name">
					<span><?php echo wp_kses_post( $product_name ); ?></span>
				</div>
			</div>
			<?php
			$cnt++;
		}

		?>
	</td>

	<td class="ywbc-order-total" valign="top">
		<?php echo wp_kses_post( $object->get_formatted_order_total() ); ?>
	</td>

	<?php if ( defined( 'YITH_WCBK_INIT' ) ) { ?>
	<td valign="top">
		<?php

		$order_object  = wc_get_order( $order_id );
		$product_names = array();

		foreach ( $order_object->get_items() as $item ) {
			$product_name     = $item->get_name();
			$product_quantity = $item->get_quantity();
			$product          = wc_get_product( $item->get_product_id() );

			if ( $product->is_type( 'booking' ) && class_exists( 'YITH_WCBK' ) ) {

				$data = yith_wcbk()->frontend->cart->woocommerce_get_item_data( array(), $item );

				foreach ( $data as $info_array ) {
					if ( ! is_array( $info_array['display'] ) ) {
						echo esc_html( $info_array['key'] . ': ' . $info_array['display'] ) . '<br>';
					} else {
						if ( ! empty( $info_array['display'] ) && $info_array['display']['number'] > 0 ) {
							echo esc_html( $info_array['display']['title'] . ': ' . $info_array['display']['number'] ) . '<br>';
						}
					}
				}
			} else {
				echo esc_html__( 'No booking info.', 'yith-woocommerce-barcodes' );
			}
		}

		?>
	</td>
	<?php } ?>

	<td class="ywbc-barcode-value" valign="top">
		<?php
		$barcode_instance = YITH_Barcode::get( $order_id );
		echo wp_kses_post( YITH_YWBC()->render_barcode( $barcode_instance ) );
		echo "<div class='ywbc-search-order-barcode-value'>" . wp_kses_post( $barcode_instance->get_display_value() ) . '</div>';
		?>
	</td>

	<td class="ywbc-order-status" valign="top">
		<?php echo wc_get_order_status_name( $object->get_status() ); ?>
	</td>
</tr>
