<?php
/**
 * Settings.
 *
 * @package YITH\CustomOrderStatus
 */

defined( 'YITH_WCCOS' ) || exit; // Exit if accessed directly.

$import_uri = wp_nonce_url( add_query_arg( array( 'yith-wcos-import-custom-statuses' => true ), admin_url() ), 'import-custom-statuses', 'yith-wcos-import_nonce' );

$settings = array(
	'settings' => array(

		'general-options' => array(
			'title' => __( 'Settings', 'yith-woocommerce-custom-order-status' ),
			'type'  => 'title',
			'desc'  => '',
		),

		'enable-shop-manager' => array(
			'id'        => 'yith-wccos-enable-shop-manager',
			'name'      => __( 'Allow shop manager to manage order statuses', 'yith-woocommerce-custom-order-status' ),
			'desc'      => __( 'Enable to allow your shop manager to create and edit custom order statuses.', 'yith-woocommerce-custom-order-status' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'yes',
		),

		/*
		'import-custom-statuses' => array(
			'name'             => __( 'Import Custom Statuses', 'yith-woocommerce-custom-order-status' ),
			'type'             => 'yith-field',
			'yith-type'        => 'html',
			'yith-display-row' => true,
			'html'             => "<a href='$import_uri' class='button button-primary'>" . __( 'Import Custom Statuses', 'yith-woocommerce-custom-order-status' ) . '</a>',
		),
		*/

		'general-options-end' => array(
			'type' => 'sectionend',
			'id'   => 'yith-wcbk-general-options',
		),

	),
);

return $settings;
