<?php
/**
 * Product table for emails.
 *
 * @package YITH\PreOrder\Templates\Emails
 * @author  YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Vars used on this template.
 *
 * @var WC_Product $_product         The product object.
 * @var WC_Order   $_order           The order object.
 * @var string     $item_id          The order item ID.
 * @var string     $old_release_date The previous release date in timestamp format.
 * @var string     $new_release_date The new release date in timestamp format.
 * @var string     $context          For which email template is the table.
 */

// Remove the filter 'woocommerce_product_is_in_stock' to show the real stock status only for the email.
remove_filter( 'woocommerce_product_is_in_stock', array( YITH_Pre_Order_Stock_Manager(), 'allow_outofstock_selling' ) );

$item_release_date = ! empty( $item_id ) && $_order instanceof WC_Order ? $_order->get_item( $item_id )->get_meta( '_ywpo_item_for_sale_date' ) : '';
$item              = ! empty( $item_id ) ? new WC_Order_Item_Product( $item_id ) : '';
$item_price        = ! empty( $item_id ) ? wc_price( $item->get_total() ) : '';

$availability = $_product->get_availability();

$show_release_date     = in_array( $context, array( 'pre-order-confirmed', 'new-pre-order' ), true );
$show_stock            = in_array( $context, array( 'pre-order-completed', 'out-of-stock' ), true );
$release_date_reminder = 'release-date-reminder' === $context;

$product_title = $_product->get_title();
if ( in_array( $context, array( 'pre-order-confirmed', 'new-pre-order', 'pre-order-completed' ), true ) ) {
	$product_title .= '&nbsp;&times;&nbsp;' . $item->get_quantity();
}

$product_release_date = ywpo_get_release_date( $_product );

$price = $_product->get_price();
if ( $item instanceof WC_Order_Item_Product && in_array( $context, array( 'pre-order-confirmed', 'new-pre-order', 'pre-order-completed', 'release-date-changed' ), true ) ) {
	$price = (float) $item->get_total() + (float) $item->get_total_tax();
}

// Restore the filter 'woocommerce_product_is_in_stock'.
add_filter( 'woocommerce_product_is_in_stock', array( YITH_Pre_Order_Stock_Manager(), 'allow_outofstock_selling' ), 10, 2 );

?>
	<table style="background-color: #f6f6f6;">
		<tr>
			<td style="padding: 20px;"><?php echo wp_kses_post( $_product->get_image( array( 120, 120 ) ) ); ?></td>
			<td style="padding: 20px; width: 75%;">
				<div style="margin-bottom: 10px;">
					<strong><?php echo esc_html( $product_title ); ?></strong>
				</div>
				<div style="margin-bottom: 10px;">
					<span><?php echo wp_kses_post( wc_price( $price ) ); ?></span>
				</div>
				<div style="margin-bottom: 10px; text-transform: uppercase; color: #bc501c; font-size: 10px;">
					<?php if ( $release_date_reminder && $product_release_date ) : ?>
						<div>
							<strong><?php echo esc_html__( 'Availability date:', 'yith-pre-order-for-woocommerce' ); ?></strong>
							<span><?php echo '&nbsp;' . esc_html( apply_filters( 'ywpo_release_date_reminder_email_date_output', ywpo_print_date( $product_release_date ), $_product ) ); ?></span>
						</div>
					<?php endif; ?>
					<?php if ( ! empty( $item_release_date ) && $show_release_date ) : ?>
						<div>
							<strong><?php echo esc_html__( 'Availability date:', 'yith-pre-order-for-woocommerce' ); ?></strong>
							<span><?php echo '&nbsp;' . esc_html( apply_filters( 'ywpo_email_item_release_date_output', ywpo_print_date( $item_release_date ), $_product, $item_id, $item_release_date ) ); ?></span>
						</div>
					<?php endif; ?>
					<?php if ( ! empty( $old_release_date ) && ! empty( $new_release_date ) ) : ?>
						<div style="color: #000;">
							<del>
								<strong><?php echo esc_html__( 'Availability date:', 'yith-pre-order-for-woocommerce' ); ?></strong>
								<span><?php echo '&nbsp;' . esc_html( apply_filters( 'ywpo_email_old_release_date_output', ywpo_print_date( $old_release_date ), $_product, $old_release_date, $new_release_date ) ); ?></span>
							</del>
						</div>
						<div>
							<strong><?php echo esc_html__( 'New availability date:', 'yith-pre-order-for-woocommerce' ); ?></strong>
							<span><?php echo '&nbsp;' . esc_html( apply_filters( 'ywpo_email_new_release_date_output', ywpo_print_date( $new_release_date ), $_product, $old_release_date, $new_release_date ) ); ?></span>
						</div>
					<?php endif; ?>
				</div>
				<?php if ( ! empty( $availability['availability'] ) && ! empty( $availability['class'] ) && $show_stock ) : ?>
					<div style="text-transform: uppercase; color: #9daf2c; font-size: 12px;">
						<?php
						switch ( $availability['class'] ) {
							case 'in-stock':
								?>
								<span style="color: #9daf2c;"><?php echo esc_html( $availability['availability'] ); ?></span>
								<?php
								break;
							case 'out-of-stock':
								?>
								<span style="color: #d01517;"><?php echo esc_html( $availability['availability'] ); ?></span>
								<?php
								break;
							case 'available-on-backorder':
								?>
								<span style="color: #bc501c;"><?php echo esc_html( $availability['availability'] ); ?></span>
								<?php
								break;
						}
						?>
					</div>
				<?php endif; ?>
			</td>
		</tr>
	</table>
<?php
if (
	isset( $_order ) && $_order instanceof WC_Order &&
	apply_filters( 'ywpo_pre_order_completed_email_show_downloads', true, $_product, $_order, $item_id ) &&
	$_order->has_downloadable_item() &&
	$_order->get_date_paid()
) {
	?>
	<div style="margin-top:20px">
		<p><?php esc_html_e( 'Downloads:', 'yith-pre-order-for-woocommerce' ); ?></p>
		<?php
		foreach ( $_order->get_items() as $item ) {
			$item_product_id = ! empty( $item['variation_id'] ) ? $item['variation_id'] : $item['product_id'];
			if ( $_product->get_id() === $item_product_id ) {
				echo wc_display_item_meta( $item );
				echo wc_display_item_downloads( $item );
			}
		}
		?>
	</div>
	<?php
}
