jQuery( function( $ ) {

    var pre_orders_list_table = $( '.ywpo-list-table_shop_order table.wp-list-table' );

    $( document ).on( 'click', function( e ) {
      window.onbeforeunload = '';
    } );

    $(  function() {
        $( '.yith-plugins_page_yith_wcpo_panel .yith-plugin-fw__panel__content__page__heading .yith-plugin-fw__panel__content__page__title' ).append( $( '.ywpo-export' ).css( 'display', 'inline-block' ) );
    } );

    // Mark cancelled orders rows in red.
    pre_orders_list_table.find( 'tbody .ywpo_status .ywpo-cancelled' ).closest( 'tr' ).addClass( 'ywpo-pre-order-cancelled' );

    function block_modal() {
        $( '.yith-plugin-fw__modal__main' ).block(
            {
                message: null,
                overlayCSS: {
                    background: '#fff',
                    opacity: 0.6
                }
            }
        );
    }

    function unblock_modal() {
        $( '.yith-plugin-fw__modal__main' ).unblock();
    }

    $( document ).on( 'click', 'a.ywpo_manage_products_button', function ( e ) {
        e.preventDefault();
        e.stopPropagation();

        $( document ).trigger( 'ywpo_manage_products_button_start', [ ywpo_manage_products_modal, $( this ) ] );

        var rows     = $( this ).closest( 'table' ).find( 'tbody .column-ywpo_products' );
        var order_id = $( this ).data( 'order_id' );
        var is_upon_release = $( this ).data( 'upon_release' );
        var data = {
            action  : 'ywpo_manage_products_modal_content',
            order_id: order_id,
            security: ywpo_manage_products_modal.create_modal_nonce
        };

        rows.block(
            {
                message: null,
                overlayCSS: {
                    background: '#fff',
                    opacity: 0.6,
                }
            }
        );
        // Hide the blockui loading spin icon to all table rows except the clicked one.
        rows.closest( 'tr' ).not( '#post-' + order_id ).find( '.blockUI.blockOverlay' ).addClass( 'hide-loading' );

        $.post( ywpo_manage_products_modal.ajax_url, data, function( response ) {
            if ( true === response.success ) {
                yith.ui.confirm(
                    {
                        title            : ywpo_manage_products_modal.title + order_id,
                        message          : response.data.message,
                        confirmButton    : ywpo_manage_products_modal.confirm_text,
                        closeAfterConfirm: false,
                        width            : ywpo_manage_products_modal.width,
                        onCreate         : function () {
                            $( document ).trigger( 'ywpo_manage_products_modal_created', [ is_upon_release, this ] );
                        }
                    }
                );
            } else {
                window.alert( 'Error: ' + response.data.error );
            }
            rows.unblock();
        } );

        $( document ).trigger( 'ywpo_manage_products_button_end', [ ywpo_manage_products_modal, $( this ) ] );
    } );

    $( document ).on( 'ywpo_manage_products_modal_created', function ( event, is_upon_release, modal ) {
        $( document ).trigger( 'ywpo_manage_products_modal_created_start', [ is_upon_release, modal, ywpo_manage_products_modal ] );

        var $confirm_button = $( '.yith-plugin-fw__confirm__button--confirm' ),
            $table          = $( '.ywpo-manage-products' ),
            $modal_footer   = $table.closest( '.yith-plugin-fw__confirm__content' ).find( '.yith-plugin-fw__confirm__footer' ),
            order_id        = $table.data( 'order_id' );

        // Refresh tooltips for new elements in modal window.
        $( document ).trigger( 'yith-plugin-fw-tips-init' );

        $confirm_button.addClass( 'ywpo-manage-products-modal-confirm-button-disabled' );

        $( '.yith-plugin-fw__action-button--ywpo-complete-action a' ).on( 'click', { type: 'complete' }, function ( e ) {
            e.preventDefault();
            pre_order_item_action( $( this ), e.data.type );
        } );

        $( '.yith-plugin-fw__action-button--ywpo-cancel-action a' ).on( 'click', { type: 'cancel' }, function ( e ) {
            e.preventDefault();
            pre_order_item_action( $( this ), e.data.type );
        } );

        $( document ).trigger( 'ywpo_manage_products_modal_created_end', [ is_upon_release, modal, ywpo_manage_products_modal ] );

        function pre_order_item_action( element, action_type ) {
            $( document ).trigger( 'ywpo_manage_products_modal_pre_order_item_action_start', [ action_type, ywpo_manage_products_modal ] );

            var item_id       = element.closest( 'tr' ).data( 'order_item_id' ),
                $row          = element.closest( 'tr' ),
                text          = 'complete' === action_type ? ywpo_manage_products_modal.completed_text : ywpo_manage_products_modal.cancelled_text,
                footer        = 'complete' === action_type ? ywpo_manage_products_modal.complete_footer : ywpo_manage_products_modal.cancel_footer;

            $table.find( '.ywpo-actions-column' ).html( '' );
            $row.find( '.ywpo-actions-column' ).html( '<i class="ywpo-manage-products-action-label ' + action_type + '">' + text + '</i>' +
                '<input type="hidden" id="ywpo-item-id" value="' + item_id + '">' +
                '<input type="hidden" id="ywpo-action-type" value="' + action_type + '">' );
            $row.find( '.ywpo-product-title, .ywpo-release-date' ).addClass( action_type );

            $confirm_button.removeClass( 'ywpo-manage-products-modal-confirm-button-disabled' );

            $modal_footer.prepend( footer );

            $( document ).trigger( 'ywpo_manage_products_modal_pre_order_item_action_end', [ action_type, ywpo_manage_products_modal ] );
        }

        $confirm_button.on( 'click', function ( e ) {
            e.preventDefault();
            $( document ).trigger( 'ywpo_manage_products_modal_confirm_button_click_start' );

            var item_id = $table.find( '#ywpo-item-id' ).val(),
                action_type = $table.find( '#ywpo-action-type' ).val();

            if ( ! item_id || ! action_type ) {
                console.log( 'Missing "#ywpo-item-id" or "#ywpo-action-type"' );
                return;
            }

            block_modal();

            var data = {
                action     : 'ywpo_pre_order_item_action',
                action_type: action_type,
                item_id    : item_id,
                order_id   : order_id,
                security   : ywpo_manage_products_modal.item_action_nonce
            };

            $( document ).trigger( 'ywpo_manage_products_modal_confirm_button_click_before_ajax', [ data, ywpo_manage_products_modal ] );

            $.post( ywpo_manage_products_modal.ajax_url, data, function( response ) {
                if ( true === response.success ) {
                    // Change the texts and remove the save button.
                    var successful_text = 'complete' === action_type ? ywpo_manage_products_modal.successful_completed : ywpo_manage_products_modal.successful_cancelled;
                    $modal_footer.find( '.ywpo-manage-products-modal-footer-top' ).html( '<span>' + successful_text + '</span>' );
                    $modal_footer.find( '.ywpo-manage-products-modal-footer-text, .yith-plugin-fw__confirm__button--confirm' ).remove();
                    $modal_footer.find( '.yith-plugin-fw__confirm__button--cancel' ).text( ywpo_manage_products_modal.close_text );

                    // Change the status icon for the pre-order item that has just been processed.
                    var row = $table.find( '#ywpo-item-id' ).closest( 'tr' ),
                        $status_icon = row.find( '.ywpo-status-column .ywpo_status_icon i' );

                    $status_icon.removeClass( 'yith-icon-time-check ywpo-waiting' );
                    if ( 'complete' === action_type ) {
                        $status_icon.addClass( 'yith-icon-check-alt ywpo-completed' );
                    } else if ( 'cancel' === action_type ) {
                        $status_icon.addClass( 'yith-icon-close-alt ywpo-cancelled' );
                    }

                    // Change behavior of close button to force reload the page after action has been performed.
                    modal.onClose = function () {
                        window.location.reload();
                    }
                } else {
                    window.alert( 'Error: ' + response );
                }
                unblock_modal();
            } );

            $( document ).trigger( 'ywpo_manage_products_modal_confirm_button_click_end' );
        } );

    } );

} );
