<?php
/**
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package YITH\PreOrder\PluginOptions
 * @author YITH <plugins@yithemes.com>
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_WCPO_VERSION' ) ) {
	exit;
}

return array(
	'general' => apply_filters(
		'ywpo_general_options',
		array(
			'general_options_start'          => array(
				'id'   => 'ywpo_general_options_start',
				'type' => 'sectionstart',
			),
			'general_title'                  => array(
				'name' => __( 'Plugin options', 'yith-pre-order-for-woocommerce' ),
				'id'   => 'ywpo_general_options_title',
				'type' => 'title',
				'desc' => '',
			),
			'enable_pre_order'               => array(
				'name'      => __( 'Enable all Pre-Order features for your visitors', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to show all pre-orders options on the frontend.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'yith_wcpo_enable_pre_order',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'yes',
			),
			'automatic_pre_order'            => array(
				'name'      => __( 'Automatically enable pre-order mode in out of stock products', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to automatically activate the pre-order mode in out of stock products. Pre-order price will be the same selling price of the product. You can edit this in the pre-order panel of each product page.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'yith_wcpo_enable_pre_order_auto_outofstock_notification',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'no',
			),
			'automatic_pre_order_mode'       => array(
				'name'      => __( 'Automatically enable pre-order mode in', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Choose how to manage the pre-order mode on out of stock products.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_automatic_pre_order_mode',
				'type'      => 'yith-field',
				'yith-type' => 'radio',
				'options'   => array(
					'all'      => __( 'All out of stock products', 'yith-pre-order-for-woocommerce' ),
					'specific' => __( 'Only specific out of stock products or categories', 'yith-pre-order-for-woocommerce' ),
				),
				'default'   => 'all',
				'deps'      => array(
					'id'    => 'yith_wcpo_enable_pre_order_auto_outofstock_notification',
					'value' => 'yes',
				),
			),
			'specific_outofstock_products'   => array(
				'name'      => __( 'Choose products', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Choose which products will have the pre-order mode enabled.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_specific_outofstock_products',
				'type'      => 'yith-field',
				'yith-type' => 'ajax-products',
				'data'      => array(
					'action'   => 'woocommerce_json_search_products_and_variations',
					'security' => wp_create_nonce( 'search-products' ),
				),
				'multiple'  => true,
				'deps'      => array(
					'id'    => 'ywpo_automatic_pre_order_mode',
					'value' => 'specific',
				),
			),
			'specific_outofstock_categories' => array(
				'name'      => __( 'Choose categories', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Choose which products categories will have the pre-order mode enabled.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_specific_outofstock_categories',
				'type'      => 'yith-field',
				'yith-type' => 'ajax-terms',
				'data'      => array(
					'placeholder' => __( 'Search for a category&hellip;', 'yith-pre-order-for-woocommerce' ),
					'taxonomy'    => 'product_cat',
				),
				'multiple'  => true,
				'deps'      => array(
					'id'    => 'ywpo_automatic_pre_order_mode',
					'value' => 'specific',
				),
			),
			'remove_pre_order_status'        => array(
				'name'      => __( 'Disable pre-order mode when the product becomes available', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to automatically remove the pre-order mode when the availability date is reached. If this option is disabled, you will need to remove the pre-order status manually on the product page.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'yith_wcpo_enable_pre_order_purchasable',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'yes',
			),
			'free_shipping'                  => array(
				'name'      => __( 'Offer free shipping for all pre-order products', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to allow customers to get free shipping when they purchase a product in pre-order mode.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_offer_free_shipping',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'no',
			),
			'pre_order_users'                => array(
				'name'      => __( 'Users that can pre-order', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Choose whether all users can buy a product in pre-order mode, only registered users or specific user roles.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_pre_order_users',
				'type'      => 'yith-field',
				'yith-type' => 'radio',
				'options'   => array(
					'all'        => __( 'All users', 'yith-pre-order-for-woocommerce' ),
					'registered' => __( 'Only registered users', 'yith-pre-order-for-woocommerce' ),
					'roles'      => __( 'Only specific user roles', 'yith-pre-order-for-woocommerce' ),
				),
				'default'   => 'all',
			),
			'allowed_roles'                  => array(
				'name'      => __( 'User roles that can pre-order', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Choose the user roles that can purchase a pre-order product.', 'yith-pre-order-for-woocommerce' ),
				'type'      => 'yith-field',
				'yith-type' => 'select',
				'class'     => 'wc-enhanced-select',
				'css'       => 'min-width:300px',
				'multiple'  => true,
				'id'        => 'ywpo_allowed_roles',
				'options'   => yith_ywpo_get_roles(),
				'default'   => array( 'customer' ),
				'deps'      => array(
					'id'    => 'ywpo_pre_order_users',
					'value' => 'roles',
					'type'  => 'hidden',
				),
			),
			'guest_users_price'              => array(
				'name'      => __( 'Pre-order price for guest users', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Choose which price to show to guest users or hide prices altogether for pre-order products.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'yith_wcpo_guest_users_price',
				'type'      => 'yith-field',
				'yith-type' => 'radio',
				'options'   => array(
					'show_pre_order_price' => __( 'Show pre-order price', 'yith-pre-order-for-woocommerce' ),
					'show_regular_price'   => __( 'Show regular price', 'yith-pre-order-for-woocommerce' ),
					'hidden_price'         => __( 'Hide price', 'yith-pre-order-for-woocommerce' ),
				),
				'default'   => 'show_pre_order_price',
			),
			'fee'                            => array(
				'name'      => __( 'Add a fee to each pre-order', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to ask users to pay a fee to buy your products in pre-order mode.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_fee',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'no',
			),
			'fee_amount'                     => array(
				/* translators: %s: currency symbol. */
				'name'              => sprintf( __( 'Pre-orders fee (%s)', 'yith-pre-order-for-woocommerce' ), esc_html( get_woocommerce_currency_symbol() ) ),
				'desc'              => __( 'Enter the fee that users have to pay in order to buy products in pre-order mode.', 'yith-pre-order-for-woocommerce' ),
				'id'                => 'ywpo_fee_amount',
				'type'              => 'yith-field',
				'yith-type'         => 'text',
				'default'           => 0,
				'class'             => 'wc_input_price',
				'deps'              => array(
					'id'    => 'ywpo_fee',
					'value' => 'yes',
					'type'  => 'hidden',
				),
				'custom_attributes' => 'required style="width:80px"',
			),
			'fee_include_tax'                => array(
				'name'      => __( 'Tax in pre-orders fee', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Choose whether the fee amount is entered inclusive or exclusive of tax. If taxes are not enabled on the shop this option will be ignored.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_fee_include_tax',
				'type'      => 'yith-field',
				'yith-type' => 'radio',
				'options'   => array(
					'yes'         => __( 'The fee amount is inclusive of tax', 'yith-pre-order-for-woocommerce' ),
					'no'          => __( 'The fee amount is exclusive of tax', 'yith-pre-order-for-woocommerce' ),
					'non-taxable' => __( 'Without tax; the pre-order fee is not taxable', 'yith-pre-order-for-woocommerce' ),
				),
				'default'   => 'yes',
				'deps'      => array(
					'id'    => 'ywpo_fee',
					'value' => 'yes',
					'type'  => 'hidden',
				),
			),
			'general_options_end'            => array(
				'id'   => 'ywpo_general_options_end',
				'type' => 'sectionend',
			),
			'cart_options_start'             => array(
				'id'   => 'ywpo_cart_options_start',
				'type' => 'sectionstart',
			),
			'cart_options_title'             => array(
				'name' => __( 'Cart options', 'yith-pre-order-for-woocommerce' ),
				'id'   => 'ywpo_cart_options_title',
				'type' => 'title',
				'desc' => '',
			),
			'prevent_mixing'                 => array(
				'name'      => __( 'Prevent the purchase of pre-order products (with upfront payment) and standard products in the same order', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( "Enable to prevent the purchase of pre-order products (with upfront payment) and regular products at the same time. Note: to avoid payment issues, users can't add products with the upon release payment option or other types of products to the same order. Also, it is not possible to buy different pre-order products with the \"upon release\" payment option in the same order.", 'yith-pre-order-for-woocommerce' ),
				'id'        => 'yith_wcpo_mixing',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'no',
			),
			'one_pre_order_in_cart'          => array(
				'name'      => __( 'Prevent more than one pre-order product with upfront payments in cart', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'By enabling this option, the cart cannot include more than one pre-order product with an upfront payment mode.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'yith_wcpo_one_pre_order_in_cart',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'no',
			),
			'cart_options_mode'              => array(
				'name'      => __( 'How to prevent the purchases', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Choose how to prevent the purchase of pre-order products', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_cart_options_mode',
				'type'      => 'yith-field',
				'yith-type' => 'radio',
				'options'   => array(
					'new'     => __( 'The customer can add the product to cart but can\'t proceed with the payment', 'yith-pre-order-for-woocommerce' ),
					'classic' => __( 'The customer can\'t add products to cart', 'yith-pre-order-for-woocommerce' ),
				),
				'default'   => 'new',
			),
			'cart_options_end'               => array(
				'id'   => 'ywpo_cart_options_end',
				'type' => 'sectionend',
			),
		)
	),
);
