<?php
/**
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package YITH\PreOrder\PluginOptions
 * @author YITH <plugins@yithemes.com>
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_WCPO_VERSION' ) ) {
	exit;
}

return array(
	'notifications' => apply_filters(
		'ywpo_notifications_options',
		array(
			'admin_notifications_start'                  => array(
				'id'   => 'ywpo_admin_notifications_start',
				'type' => 'sectionstart',
			),
			'admin_notifications_title'                  => array(
				'name' => esc_html__( 'Admin Notifications', 'yith-pre-order-for-woocommerce' ),
				'id'   => 'ywpo_admin_notifications_title',
				'type' => 'title',
				'desc' => __( 'Manage these emails in <a href="admin.php?page=wc-settings&tab=email">WooCommerce > Settings > Emails.</a>', 'yith-pre-order-for-woocommerce' ),
			),
			'admin_notification_release_date_reminder'   => array(
				'name'      => __( 'Email when a pre-order availability date is near', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to receive an email when the availability date of a product in pre-order mode is near.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'yith_wcpo_enable_pre_order_notification',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'yes',
			),
			'release_date_near_number_of_days'           => array(
				'name'                 => __( 'The email will be sent', 'yith-pre-order-for-woocommerce' ),
				'desc'                 => '',
				'id'                   => 'yith_wcpo_notification_number_days',
				'type'                 => 'yith-field',
				'yith-type'            => 'number',
				'min'                  => 0,
				'default'              => 1,
				'yith-wcpo-after-html' => __( 'day(s) before the availability date.', 'yith-pre-order-for-woocommerce' ),
				'custom_attributes'    => 'required style="vertical-align:inherit;"',
				'deps'                 => array(
					'id'    => 'yith_wcpo_enable_pre_order_notification',
					'value' => 'yes',
					'type'  => 'hidden',
				),
			),
			'admin_notification_user_purchase'           => array(
				'name'      => __( 'Email when a pre-order product is sold', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to receive an email when a new order is placed for a pre-order product.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_new_pre_order_email_notification_enabled',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'yes',
			),
			'admin_notifications_end'                    => array(
				'id'   => 'ywpo_admin_notifications_end',
				'type' => 'sectionend',
			),
			'customers_notifications_start'              => array(
				'id'   => 'ywpo_customers_notifications_start',
				'type' => 'sectionstart',
			),
			'customers_notifications_title'              => array(
				'name' => esc_html__( 'Customers Notifications', 'yith-pre-order-for-woocommerce' ),
				'id'   => 'ywpo_customers_notifications_title',
				'type' => 'title',
			),
			'customer_notification_purchase'             => array(
				'name'      => __( 'Pre-order confirmation email', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to automatically send an email to customers when they pre-order a product.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_confirmed_email_notification_enabled',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'yes',
			),
			'customer_notification_released'             => array(
				'name'      => __( 'Email upon pre-order product release', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to automatically send an email to customers when a pre-order product they purchased is released.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_completed_email_notification_enabled',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'yes',
			),
			'customer_notification_cancelled_pre_order'  => array(
				'name'      => __( 'Email when a pre-order is cancelled', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to automatically send an email to customers when an ongoing pre-order is cancelled by the admin.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_cancelled_email_notification_enabled',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'yes',
			),
			'customer_notification_release_date_changed' => array(
				'name'      => __( 'Email when the availability date is changed', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to automatically send an email to customers when a released date for a product they pre-ordered is changed.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_release_date_change_email_enabled',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'no',
			),
			'customer_notification_payment_reminder'     => array(
				'name'      => __( 'Payment reminder email', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to automatically send an email to customers that placed a pre-order with the upon release payment option to remind them that the payment is pending.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_payment_reminder_email_notification_enabled',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'yes',
			),
			'payment_reminder_number_of_days'            => array(
				'name'                 => __( 'Send payment reminder', 'yith-pre-order-for-woocommerce' ),
				'desc'                 => '',
				'id'                   => 'ywpo_payment_reminder_number_of_days',
				'type'                 => 'yith-field',
				'yith-type'            => 'number',
				'min'                  => 0,
				'default'              => 1,
				'yith-wcpo-after-html' => __( 'day(s) after the product release.', 'yith-pre-order-for-woocommerce' ),
				'custom_attributes'    => 'required style="vertical-align:inherit;"',
				'deps'                 => array(
					'id'    => 'ywpo_payment_reminder_enabled',
					'value' => 'yes',
					'type'  => 'hidden',
				),
			),

			'customers_notifications_end'                => array(
				'id'   => 'ywpo_customers_notifications_end',
				'type' => 'sectionend',
			),
		)
	),
);
