<?php
/**
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package YITH\PreOrder\PluginOptions
 * @author YITH <plugins@yithemes.com>
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_WCPO_VERSION' ) ) {
	exit;
}

return array(
	'style' => apply_filters(
		'ywpo_style_options',
		array(
			'style_options_start'                 => array(
				'id'   => 'ywpo_style_options_start',
				'type' => 'sectionstart',
			),
			'style_title'                         => array(
				'name' => __( 'Plugin Style', 'yith-pre-order-for-woocommerce' ),
				'id'   => 'ywpo_style_options_title',
				'type' => 'title',
				'desc' => '',
			),
			'automatic_date_formatting'           => array(
				'name'      => __( "Show date according to the user's format", 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( "Enable to automatically display the date format and timezone based on the user's location in the frontend.", 'yith-pre-order-for-woocommerce' ),
				'id'        => 'yith_wcpo_enable_automatic_date_formatting',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'yes',
			),
			'show_regular_price'                  => array(
				'name'      => __( 'Product price', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Choose how to show the price of a pre-order product.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'yith_wcpo_show_regular_price',
				'type'      => 'yith-field',
				'yith-type' => 'radio',
				'options'   => array(
					'no'  => __( 'Hide the regular sale price', 'yith-pre-order-for-woocommerce' ),
					'yes' => __( 'Show the regular sale price crossed out', 'yith-pre-order-for-woocommerce' ),
				),
				'default'   => 'yes',
			),
			'show_fee'                            => array(
				'name'      => __( 'Show fee cost on product page', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to show the fee cost on the product page, near the product price.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_show_fee_on_product_page',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'no',
			),
			'fee_label'                           => array(
				'name'          => __( 'Fee label', 'yith-pre-order-for-woocommerce' ),
				'desc'          => __( 'Enter the label that identifies the fee applied to products in pre-order mode.', 'yith-pre-order-for-woocommerce' ),
				'id'            => 'ywpo_product_page_fee_label',
				'type'          => 'yith-field',
				'yith-type'     => 'textarea-editor',
				'media_buttons' => false,
				'textarea_rows' => 5,
				'default'       => __( '<br><span style="color: #467484;">+ a fee of {fee}</span>', 'yith-pre-order-for-woocommerce' ),
				'deps'          => array(
					'id'    => 'ywpo_show_fee_on_product_page',
					'value' => 'yes',
					'type'  => 'hidden',
				),
			),
			'default_add_to_cart_label'           => array(
				'name'              => __( 'Pre-order button label', 'yith-pre-order-for-woocommerce' ),
				'desc'              => __( 'Enter the label that replaces the default "Add to cart" label in products in pre-order mode.', 'yith-pre-order-for-woocommerce' ),
				'id'                => 'yith_wcpo_default_add_to_cart_label',
				'type'              => 'yith-field',
				'yith-type'         => 'text',
				'default'           => __( 'Pre-order now', 'yith-pre-order-for-woocommerce' ),
				'custom_attributes' => 'style="width:200px"',
			),
			'customize_pre_order_button'          => array(
				'name'      => __( "Customize the pre-order button's colors", 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to set a different color for the pre-order button (the "Add to cart" button will keep the theme colors).', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_customize_pre_order_button',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'no',
			),
			'pre_order_button_colors'             => array(
				'name'         => __( 'Pre-order button colors', 'yith-pre-order-for-woocommerce' ),
				'desc'         => __( 'Set the colors of the pre-order button.', 'yith-pre-order-for-woocommerce' ),
				'id'           => 'ywpo_pre_order_button_colors',
				'type'         => 'yith-field',
				'yith-type'    => 'multi-colorpicker',
				'colorpickers' => array(
					array(
						'id'      => 'ywpo_background_color',
						'name'    => __( 'Background', 'yith-pre-order-for-woocommerce' ),
						'default' => '#af2323',
					),
					array(
						'id'      => 'ywpo_background_hover_color',
						'name'    => __( 'Background hover', 'yith-pre-order-for-woocommerce' ),
						'default' => '#af2323',
					),
					array(
						'id'      => 'ywpo_text_color',
						'name'    => __( 'Text', 'yith-pre-order-for-woocommerce' ),
						'default' => '#fff',
					),
					array(
						'id'      => 'ywpo_text_hover_color',
						'name'    => __( 'Text hover', 'yith-pre-order-for-woocommerce' ),
						'default' => '#fff',
					),
				),
				'deps'         => array(
					'id'    => 'ywpo_customize_pre_order_button',
					'value' => 'yes',
					'type'  => 'hidden',
				),
			),
			'availability_date_text'              => array(
				'name'          => __( 'Text to show in products with availability date', 'yith-pre-order-for-woocommerce' ),
				'desc'          => __( 'Enter the default text to inform users about the availability date.', 'yith-pre-order-for-woocommerce' ) . '<br>' .
								/* translators: placeholders with HTML format that must no be modified. %1$s: '<strong>{availability_date}</strong>' %2$s: '<strong>{availability_time}</strong>' */
								sprintf( __( 'Use %1$s and %2$s to show the date and time.', 'yith-pre-order-for-woocommerce' ), '<strong>{availability_date}</strong>', '<strong>{availability_time}</strong>' ),
				'id'            => 'yith_wcpo_default_availability_date_label',
				'type'          => 'yith-field',
				'yith-type'     => 'textarea-editor',
				'media_buttons' => false,
				'textarea_rows' => 5,
				/* translators: placeholders %1$s: date %2$s: time */
				'default'       => sprintf( __( 'Available on: %1$s at %2$s', 'yith-pre-order-for-woocommerce' ), '{availability_date}', '{availability_time}' ),
			),
			'no_date_text'                        => array(
				'name'          => __( 'Text to show in products without availability date', 'yith-pre-order-for-woocommerce' ),
				'desc'          => __( 'Enter the default text to show products without an availability date.', 'yith-pre-order-for-woocommerce' ),
				'id'            => 'yith_wcpo_no_date_label',
				'type'          => 'yith-field',
				'yith-type'     => 'textarea-editor',
				'media_buttons' => false,
				'textarea_rows' => 5,
				/* translators: placeholders %1$s: date %2$s: time */
				'default'       => __( 'Stay updated, this item will be available soon!', 'yith-pre-order-for-woocommerce' ),
			),
			'availability_in_shop'                => array(
				'name'      => __( 'Show availability text in the Shop pages', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to show the availability text in the Shop pages.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_availability_in_shop',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'yes',
			),
			'availability_in_cart'                => array(
				'name'      => __( 'Show availability text in the cart', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to show the availability text in the cart.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_availability_in_cart',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'yes',
			),
			'variable_product_label_enabled'      => array(
				'name'      => __( 'Show an additional text in variable pre-order products', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( "Enable to show an additional custom text when all of a product's variations are in pre-order mode.", 'yith-pre-order-for-woocommerce' ),
				'id'        => 'yith_wcpo_variable_product_label_enabled',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'no',
			),
			'variable_product_label'              => array(
				'name'          => __( 'Additional text in variable pre-order products', 'yith-pre-order-for-woocommerce' ),
				'desc'          => '',
				'id'            => 'yith_wcpo_variable_product_label_content',
				'type'          => 'yith-field',
				'yith-type'     => 'textarea-editor',
				'media_buttons' => false,
				'textarea_rows' => 5,
				'default'       => __( 'Pre-Order', 'yith-pre-order-for-woocommerce' ),
				'deps'          => array(
					'id'    => 'yith_wcpo_variable_product_label_enabled',
					'value' => 'yes',
					'type'  => 'hidden',
				),
			),
			'customize_place_order_button'        => array(
				'name'      => __( 'Customize the "Place order" button at checkout', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Enable to customize the text and color of the "Place order" button at checkout.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_custom_place_order_button_enabled',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
				'default'   => 'no',
			),
			'customize_place_order_button_label'  => array(
				'name'              => __( '"Place order" button label', 'yith-pre-order-for-woocommerce' ),
				'desc'              => __( 'Enter the label that replaces the default "Place order" button label in the Checkout page.', 'yith-pre-order-for-woocommerce' ),
				'id'                => 'ywpo_custom_place_order_button_label',
				'type'              => 'yith-field',
				'yith-type'         => 'text',
				'default'           => __( 'Place pre-order now', 'yith-pre-order-for-woocommerce' ),
				'deps'              => array(
					'id'    => 'ywpo_custom_place_order_button_enabled',
					'value' => 'yes',
					'type'  => 'hidden',
				),
				'custom_attributes' => 'style="width:200px"',
			),
			'customize_place_order_button_colors' => array(
				'name'      => __( '"Place order" button color', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Choose if you want to customize the "Place order" button colors or not.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'ywpo_custom_place_order_button_colors',
				'type'      => 'yith-field',
				'yith-type' => 'radio',
				'options'   => array(
					'default' => __( 'Use the default one', 'yith-pre-order-for-woocommerce' ),
					'custom'  => __( 'Use custom colors', 'yith-pre-order-for-woocommerce' ),
				),
				'default'   => 'default',
				'deps'      => array(
					'id'    => 'ywpo_custom_place_order_button_enabled',
					'value' => 'yes',
					'type'  => 'hidden',
				),
			),
			'place_order_button_colors'           => array(
				'name'         => __( 'Colors', 'yith-pre-order-for-woocommerce' ),
				'desc'         => __( 'Set the colors of the "Place order" button.', 'yith-pre-order-for-woocommerce' ),
				'id'           => 'ywpo_place_order_colors',
				'type'         => 'yith-field',
				'yith-type'    => 'multi-colorpicker',
				'colorpickers' => array(
					array(
						'id'      => 'ywpo_place_order_background_color',
						'name'    => __( 'Background', 'yith-pre-order-for-woocommerce' ),
						'default' => '#af2323',
					),
					array(
						'id'      => 'ywpo_place_order_background_hover_color',
						'name'    => __( 'Background hover', 'yith-pre-order-for-woocommerce' ),
						'default' => 'rgb(226,89,89)',
					),
					array(
						'id'      => 'ywpo_place_order_text_color',
						'name'    => __( 'Text', 'yith-pre-order-for-woocommerce' ),
						'default' => '#fff',
					),
					array(
						'id'      => 'ywpo_place_order_text_hover_color',
						'name'    => __( 'Text hover', 'yith-pre-order-for-woocommerce' ),
						'default' => 'rgb(247,247,247)',
					),
				),
				'deps'         => array(
					'id'    => 'ywpo_custom_place_order_button_colors',
					'value' => 'custom',
					'type'  => 'hidden',
				),
			),
			'style_options_end'                   => array(
				'id'   => 'ywpo_style_options_end',
				'type' => 'sectionend',
			),
		)
	),
);
