<?php
/**
 * Edit product Pre-Order tab options
 *
 * @package YITH\PreOrder\Templates\Admin
 * @since   2.0.0
 * @author  YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Vars used on this template.
 *
 * @var string $type Footer type 'complete'|'cancel'.
 */

?>
<div class="ywpo-manage-products-modal-footer" style="text-align: left">
	<div class="ywpo-manage-products-modal-footer-top">
		<?php
		$footer_top = '';
		switch ( $type ) {
			case 'complete':
				$footer_top = __( 'Are you sure you want to complete this pre-order?', 'yith-pre-order-for-woocommerce' );
				break;
			case 'cancel':
				$footer_top = __( 'Are you sure you want to cancel this pre-order?', 'yith-pre-order-for-woocommerce' );
		}
		echo esc_html( $footer_top );
		?>
	</div>
	<div class="ywpo-manage-products-modal-footer-text">
		<span><?php echo esc_html( __( 'This action cannot be undone and the customer will receive an email.' ) ); ?></span>
	</div>
</div>
