<?php
/**
 * Email template
 *
 * @package YITH\PreOrder\Templates\Emails
 * @author  YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Vars used on this template.
 *
 * @var string $email_heading The email heading.
 * @var YITH_Pre_Order_Release_Date_Changed_Email $email The WC_Email object.
 */

do_action( 'woocommerce_email_header', $email_heading, $email );

$body     = ! empty( $email->email_body ) ? $email->email_body : '';
$_product = ! empty( $email->data['product_id'] ) ? wc_get_product( $email->data['product_id'] ) : '';

$old_release_date = ! empty( $email->data['old_release_date'] ) ? $email->data['old_release_date'] : '';
$new_release_date = ! empty( $email->data['new_release_date'] ) ? $email->data['new_release_date'] : '';

$product_table = wc_get_template_html(
	'emails/ywpo-product-table.php',
	array(
		'_product'         => $_product,
		'old_release_date' => $old_release_date,
		'new_release_date' => $new_release_date,
		'context'          => 'release-date-changed',
	),
	'',
	YITH_WCPO_TEMPLATE_PATH
);

do_action( 'ywpo_release_date_changed_email_before_body', $email, $body, $_product, $old_release_date, $new_release_date, $product_table );

echo wp_kses_post(
	apply_filters(
		'ywpo_release_date_changed_email_body',
		'<p>' . str_replace( array( '{product_table}' ), array( $product_table ), nl2br( $body ) ) . '</p>',
		$email,
		$body,
		$_product,
		$old_release_date,
		$new_release_date,
		$product_table
	)
);

do_action( 'ywpo_release_date_changed_email_after_body', $email, $body, $_product, $old_release_date, $new_release_date, $product_table );

do_action( 'woocommerce_email_footer', $email );
