<?php
/**
 * Plugin Name: YITH Pre-Order for WooCommerce Premium
 * Plugin URI: https://yithemes.com/themes/plugins/yith-woocommerce-pre-order
 * Description: Thanks to <code><strong>YITH Pre-Order for WooCommerce Premium</strong></code> you can immediately improve the sales of unavailable items, offering your customers the chance to purchase the products and receive them only after they are officially on sale. <a href="https://yithemes.com/" target="_blank">Get more plugins for your e-commerce on <strong>YITH</strong></a>.
 * Version: 3.12.0
 * Author: YITH
 * Author URI: https://yithemes.com/
 * Text Domain: yith-pre-order-for-woocommerce
 * Domain Path: /languages/
 * WC requires at least: 10.2
 * WC tested up to: 10.4
 * Requires Plugins: woocommerce
 *
 * @package YITH\PreOrder
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

if ( ! function_exists( 'yit_deactive_free_version' ) ) {
	require_once 'plugin-fw/yit-deactive-plugin.php';
}
yit_deactive_free_version( 'YITH_WCPO_FREE_INIT', plugin_basename( __FILE__ ) );

/* === DEFINE === */
! defined( 'YITH_WCPO_VERSION' ) && define( 'YITH_WCPO_VERSION', '3.12.0' );
! defined( 'YITH_WCPO_INIT' ) && define( 'YITH_WCPO_INIT', plugin_basename( __FILE__ ) );
! defined( 'YITH_WCPO_SLUG' ) && define( 'YITH_WCPO_SLUG', 'yith-woocommerce-pre-order' );
! defined( 'YITH_WCPO_SECRETKEY' ) && define( 'YITH_WCPO_SECRETKEY', 'IuVtJPflp0YXWOXGW0uW' );
! defined( 'YITH_WCPO_FILE' ) && define( 'YITH_WCPO_FILE', __FILE__ );
! defined( 'YITH_WCPO_PATH' ) && define( 'YITH_WCPO_PATH', plugin_dir_path( __FILE__ ) );
! defined( 'YITH_WCPO_URL' ) && define( 'YITH_WCPO_URL', plugins_url( '/', __FILE__ ) );
! defined( 'YITH_WCPO_ASSETS_URL' ) && define( 'YITH_WCPO_ASSETS_URL', YITH_WCPO_URL . 'assets/' );
! defined( 'YITH_WCPO_ASSETS_JS_URL' ) && define( 'YITH_WCPO_ASSETS_JS_URL', YITH_WCPO_URL . 'assets/js/' );
! defined( 'YITH_WCPO_TEMPLATE_PATH' ) && define( 'YITH_WCPO_TEMPLATE_PATH', YITH_WCPO_PATH . 'templates/' );
! defined( 'YITH_WCPO_OPTIONS_PATH' ) && define( 'YITH_WCPO_OPTIONS_PATH', YITH_WCPO_PATH . 'plugin-options' );
! defined( 'YITH_WCPO_PREMIUM' ) && define( 'YITH_WCPO_PREMIUM', '1' );

// Plugin Framework Loader.
if ( file_exists( plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php' ) ) {
    require_once plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php';
}

register_activation_hook( YITH_WCPO_FILE, 'pre_order_2_0_update_helper' );
register_deactivation_hook( YITH_WCPO_FILE, 'ywpo_rewrite_rules' );

if ( ! function_exists( 'pre_order_2_0_update_helper' ) ) {
	/**
	 * Add the new post meta to the orders with pre-order items made with previous versions of the Pre-Order plugin.
	 */
	function pre_order_2_0_update_helper() {
		// This is to ensure that this function is executed only once on installations that were using the plugin
		// previously: If there is the option 'yith_wcpo_enable_pre_order' (regardless of the value 'yes' or 'no'),
		// it means that the plugin was previously installed before the update.
		if ( get_option( 'yith_wcpo_enable_pre_order' ) && 'no' === get_option( 'ywpo_update_2_0_done', 'no' ) ) {
			require_once YITH_WCPO_PATH . 'includes/functions-pre-order-update.php';
			ywpo_update_2_0();
		}
	}
}

if ( ! function_exists( 'ywpo_declare_wc_features_support' ) ) {
	/**
	 * Declare support for WooCommerce features.
	 */
	function ywpo_declare_wc_features_support() {
		if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', YITH_WCPO_INIT, true );
		}
	}
}

if ( ! function_exists( 'ywpo_declare_wc_cart_checkout_blocks_support' ) ) {
	add_action( 'before_woocommerce_init', 'ywpo_declare_wc_cart_checkout_blocks_support' );
	/**
	 * Declare incompatibility for Cart and Checkout blocks. Compatibility in progress.
	 */
	function ywpo_declare_wc_cart_checkout_blocks_support() {
		if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', __FILE__, false );
		}
	}
}

if ( ! function_exists( 'ywpo_rewrite_rules' ) ) {
	/**
	 * When deactivating the plugin, delete the flag option for updating permalink structure
	 */
	function ywpo_rewrite_rules() {
		delete_option( 'yith-ywpo-flush-rewrite-rules' );
	}
}

/* Start the plugin on plugins_loaded */

if ( ! function_exists( 'yith_ywpo_install' ) ) {
	/**
	 * Install the plugin
	 */
	function yith_ywpo_install() {
		if ( ! function_exists( 'WC' ) ) {
			add_action( 'admin_notices', 'yith_ywpo_install_woocommerce_admin_notice' );
		} else {
			add_action( 'before_woocommerce_init', 'ywpo_declare_wc_features_support' );
			do_action( 'yith_ywpo_init' );
		}
	}
	add_action( 'plugins_loaded', 'yith_ywpo_install', 12 );
}

if ( ! function_exists( 'yith_ywpo_install_woocommerce_admin_notice' ) ) {
	/**
	 * Admin notice in case WooCommerce is not activated.
	 */
	function yith_ywpo_install_woocommerce_admin_notice() {
		?>
		<div class="error">
			<p><?php esc_html_e( 'YITH Pre Order for WooCommerce is enabled but not effective. It requires WooCommerce in order to work.', 'yith-pre-order-for-woocommerce' ); ?></p>
		</div>
		<?php
	}
}

add_action( 'yith_ywpo_init', 'yith_ywpo_init' );

if ( ! function_exists( 'yith_ywpo_init' ) ) {
	/**
	 * Start the plugin
	 */
	function yith_ywpo_init() {
		/**
		 * Load text domain
		 */
        if ( function_exists( 'yith_plugin_fw_load_plugin_textdomain' ) ) {
            yith_plugin_fw_load_plugin_textdomain( 'yith-pre-order-for-woocommerce', basename( dirname( __FILE__ ) ) . '/languages' );
        }

		require_once YITH_WCPO_PATH . 'includes/class-yith-pre-order.php';
		if ( defined( 'YITH_WCPO_PREMIUM' ) && file_exists( YITH_WCPO_PATH . 'includes/class-yith-pre-order-premium.php' ) ) {

			require_once YITH_WCPO_PATH . 'includes/class-yith-pre-order-premium.php';
			return YITH_Pre_Order_Premium();
		}

		return YITH_Pre_Order();
	}
}
