<?php
/**
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package YITH\PreOrder\Templates\Admin
 * @author YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Vars used on this template.
 *
 * @var WC_Product $product                      The product object.
 * @var int        $loop                         Position in the loop.
 * @var string     $pre_order_status             Whether Pre-Order status is enabled or not for this product.
 * @var string     $pre_order_mode               Whether the Pre-Order status is configured automatically or manually.
 * @var string     $override_pre_order_mode      Whether the Automatic Pre-Order status for out-of-stock products is overridden or not.
 * @var string     $start_mode                   Whether the Start date is enabled or not.
 * @var string     $start_date                   Start date timestamp.
 * @var string     $start_date_label             Start date label.
 * @var string     $availability_date_mode       Type of availability date used.
 * @var string     $availability_date            Standard availability date. Exact date and exact time.
 * @var string     $dynamic_availability_date    Number of days for the availability date dynamically calculated.
 * @var string     $offset_label                 Display the current time offset configured in WordPress.
 * @var string     $price_mode                   Price mode.
 * @var string     $preorder_price               Pre-Order price.
 * @var string     $discount_percentage          Discount the Pre-Order price by percentage.
 * @var string     $discount_fixed               Discount the Pre-Order price by a fixed amount.
 * @var string     $increase_percentage          Increase the Pre-Order price by percentage.
 * @var string     $increase_fixed               Increase the Pre-Order price by a fixed amount.
 * @var string     $max_qty_enabled              Whether if maximum quantity option is enabled or not.
 * @var string     $max_qty                      Maximum quantity.
 * @var string     $override_labels              Whether to override the global label settings or not.
 * @var string     $pre_order_label              Pre-order label.
 * @var string     $availability_date_label      Availability date label.
 * @var string     $no_date_label                No date label.
 * @var string     $override_fee                 Whether to override the Pre-Order Fee global setting or not.
 * @var string     $fee                          Fee value.
 * @var string     $override_charge_type         Whether to override the Pre-Order charge type or not.
 * @var string     $charge_type                  Charge type - Upfront or Upon release.
 */

$offset_label = '(' . ywpo_get_timezone_offset_label() . ')';
?>
<div class="show_if_variation_pre_order woocommerce_options_panel">
	<div class="options_group ywpo_options_group">
		<h4 class="ywpo_options_panel_title"><?php esc_html_e( 'Pre-order options', 'yith-pre-order-for-woocommerce' ); ?></h4>
		<fieldset class="form-field yith-plugin-ui ywpo_preorder onoff">
			<legend for="_ywpo_preorder"><?php esc_html_e( 'Manage pre-order options for this product', 'yith-pre-order-for-woocommerce' ); ?></legend>
			<?php
			yith_plugin_fw_get_field(
				array(
					'type'  => 'onoff',
					'id'    => '_ywpo_preorder[' . $loop . ']',
					'name'  => '_ywpo_preorder[' . $loop . ']',
					'value' => $pre_order_status,
				),
				true
			);
			?>
			<span class="description"><?php esc_html_e( 'Enable to set pre-order options for this product.', 'yith-pre-order-for-woocommerce' ); ?></span>
		</fieldset>
		<div class="form-field" data-deps-on="_ywpo_preorder[<?php echo esc_attr( $loop ); ?>]" data-deps-val="yes">
			<?php $auto_pre_order_condition = ywpo_product_is_eligible_for_auto_pre_order( $product ); ?>
			<?php if ( $auto_pre_order_condition ) : ?>
				<fieldset style="margin: 10px; padding: 15px; border: solid 1px darkgrey; background-color: #f5f5f5; width: 800px;">
					<?php $options_url = get_admin_url() . 'admin.php?page=yith_wcpo_panel&tab=general'; ?>
					<?php /* translators: placeholders %s: general settings URL */ ?>
					<div><i><?php printf( wp_kses_post( __( 'In this product, the <strong>automatic pre-order mode</strong> is active (due to the option enabled in <a href="%s" target="_blank">YITH Pre-Order > General Options</a>).', 'yith-pre-order-for-woocommerce' ) ), $options_url ); ?></i></div>
					<div><i><?php printf( esc_html__( 'Choose if you want to keep the product in automatic pre-order mode or if you want to override the rule in General Options to set pre-order options manually only for this product.', 'yith-pre-order-for-woocommerce' ) ); ?></i></div>
				</fieldset>
				<?php
				woocommerce_wp_radio(
					array(
						'label'   => __( 'Put the product in pre-order mode', 'yith-pre-order-for-woocommerce' ),
						'value'   => $override_pre_order_mode,
						'id'      => '_ywpo_override_pre_order_mode[' . $loop . ']',
						'name'    => '_ywpo_override_pre_order_mode[' . $loop . ']',
						'options' => array(
							'auto'   => __( 'Keep the product in automatic pre-order mode', 'yith-pre-order-for-woocommerce' ),
							'manual' => __( 'Use manual pre-order options and override the automatic pre-order option', 'yith-pre-order-for-woocommerce' ),
						),
					)
				);
				?>
			<?php else : ?>
				<?php
				woocommerce_wp_radio(
					array(
						'label'   => __( 'Put the product in pre-order mode', 'yith-pre-order-for-woocommerce' ),
						'value'   => $pre_order_mode,
						'id'      => '_ywpo_pre_order_mode[' . $loop . ']',
						'name'    => '_ywpo_pre_order_mode[' . $loop . ']',
						'options' => array(
							'manual' => __( 'Manually', 'yith-pre-order-for-woocommerce' ),
							'auto'   => __( 'Automatically when the product is out of stock', 'yith-pre-order-for-woocommerce' ),
						),
					)
				);
				?>
			<?php endif; ?>
			<p class="form-field yith-plugin-ui _ywpo_pre_order_mode-description">
				<span class="description"><?php esc_html_e( 'Choose how to enable the pre-order mode for this product.', 'yith-pre-order-for-woocommerce' ); ?></span>
				<span class="description"><?php esc_html_e( 'If you choose "automatically", the pre-order mode will be automatically disabled when the product is back in stock.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</p>

			<div class="form-field" data-deps-on="<?php echo $auto_pre_order_condition ? esc_attr( '_ywpo_override_pre_order_mode[' . $loop . ']' ) : esc_attr( '_ywpo_pre_order_mode[' . $loop . ']' ); ?>" data-deps-val="manual">
				<?php
				woocommerce_wp_radio(
					array(
						'label'   => __( 'Pre-order period start', 'yith-pre-order-for-woocommerce' ),
						'value'   => $start_mode,
						'id'      => '_ywpo_start_mode[' . $loop . ']',
						'name'    => '_ywpo_start_mode[' . $loop . ']',
						'options' => array(
							'now'  => __( 'Immediately', 'yith-pre-order-for-woocommerce' ),
							'date' => __( 'Schedule a start date for the pre-order mode', 'yith-pre-order-for-woocommerce' ),
						),
					)
				);
				?>
				<p class="form-field yith-plugin-ui _ywpo_start_mode-description">
					<span class="description"><?php esc_html_e( 'Choose to set the product in pre-order mode now or schedule it.', 'yith-pre-order-for-woocommerce' ); ?></span>
				</p>

				<fieldset class="form-field yith-plugin-ui ywpo_start_date" data-deps-on="_ywpo_start_mode[<?php echo esc_attr( $loop ); ?>]" data-deps-val="date">
					<legend for="_ywpo_start_date"><?php esc_html_e( 'Pre-order start day', 'yith-pre-order-for-woocommerce' ); ?></legend>
					<?php
					$start_date_field = array(
						'id'    => '_ywpo_start_date_' . $loop,
						'name'  => '_ywpo_start_date[' . $loop . ']',
						'type'  => 'datepicker',
						'class' => 'ywpo_datetimepicker',
						'data'  => array(
							'date-format' => 'yy-mm-dd',
							'min-date'    => 0,
						),
						'value' => $start_date,
					);
					?>
					<?php yith_plugin_fw_get_field( $start_date_field, true ); ?>
					<span class="yith-icon yith-icon-calendar yith-icon--right-overlay"></span>
				</fieldset>
				<p class="form-field yith-plugin-ui ywpo_start_date-description" data-deps-on="_ywpo_start_mode[<?php echo esc_attr( $loop ); ?>]" data-deps-val="date">
					<span class="description"><?php esc_html_e( 'Set the date when this product will be available to be purchased in pre-order mode.', 'yith-pre-order-for-woocommerce' ); ?></span>
				</p>

				<fieldset class="form-field ywpo_start_date_label" data-deps-on="_ywpo_start_mode[<?php echo esc_attr( $loop ); ?>]" data-deps-val="date">
					<legend for="_ywpo_start_date_label"><?php esc_html_e( 'Pre-order start day label', 'yith-pre-order-for-woocommerce' ); ?></legend>
					<?php
					yith_plugin_fw_get_field(
						array(
							'id'            => '_ywpo_start_date_label' . $loop,
							'name'          => '_ywpo_start_date_label[' . $loop . ']',
							'type'          => 'textarea-editor',
							'media_buttons' => false,
							'textarea_rows' => 5,
							'value'         => $start_date_label,
						),
						true
					);
					?>
				</fieldset>
				<p class="form-field yith-plugin-ui _ywpo_start_date_label-description" data-deps-on="_ywpo_start_mode[<?php echo esc_attr( $loop ); ?>]" data-deps-val="date">
					<span class="description"><?php esc_html_e( 'Customize the text to announce the start day. You can use the placeholders {availability_date} and {availability_time}.', 'yith-pre-order-for-woocommerce' ); ?></span>
				</p>

				<?php
				woocommerce_wp_radio(
					array(
						'label'         => __( 'Set product availability date', 'yith-pre-order-for-woocommerce' ),
						'value'         => $availability_date_mode,
						'id'            => '_ywpo_availability_date_mode[' . $loop . ']',
						'name'          => '_ywpo_availability_date_mode[' . $loop . ']',
						'wrapper_class' => 'ywpo_availability_date_mode',
						'default'       => 'no_date',
						'options'       => array(
							'no_date' => __( 'No date - end pre-order mode manually', 'yith-pre-order-for-woocommerce' ),
							'date'    => __( 'Choose a date from the calendar', 'yith-pre-order-for-woocommerce' ),
							'dynamic' => __( 'Available X days after the user pre-orders it', 'yith-pre-order-for-woocommerce' ),
						),
					)
				);
				?>
				<p class="form-field yith-plugin-ui _ywpo_availability_date_mode-description">
					<span class="description"><?php esc_html_e( 'Choose how to manage the availability date.', 'yith-pre-order-for-woocommerce' ); ?></span>
				</p>

				<fieldset class="form-field yith-plugin-ui _ywpo_availability_date" data-deps-on="_ywpo_availability_date_mode[<?php echo esc_attr( $loop ); ?>]" data-deps-val="date">
					<legend for="_ywpo_for_sale_date">
						<?php echo esc_html__( 'Availability date and time', 'yith-pre-order-for-woocommerce' ) . ' ' . esc_attr( $offset_label ); ?>
					</legend>
					<?php
					$availability_date_field = array(
						'id'    => '_ywpo_for_sale_date_' . $loop,
						'name'  => '_ywpo_for_sale_date[' . $loop . ']',
						'type'  => 'datepicker',
						'class' => 'ywpo_datetimepicker',
						'data'  => array(
							'date-format' => 'yy-mm-dd',
							'min-date'    => 0,
						),
						'value' => $availability_date,
					);
					?>
					<?php yith_plugin_fw_get_field( $availability_date_field, true ); ?>
					<span class="yith-icon yith-icon-calendar yith-icon--right-overlay"></span>
					<?php echo wc_help_tip( esc_html__( 'Set the date when the product will become available for sale. The timezone used is the WordPress local timezone in Settings -> General -> Timezone.', 'yith-pre-order-for-woocommerce' ) ); /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */ ?>
					<span class="ywpo-description"><?php esc_html_e( 'Set the date when this product will become available.', 'yith-pre-order-for-woocommerce' ); ?></span>
				</fieldset>

				<fieldset class="form-field _ywpo_dynamic_availability_date" data-deps-on="_ywpo_availability_date_mode[<?php echo esc_attr( $loop ); ?>]" data-deps-val="dynamic">
					<legend for="ywpo_dynamic_availability_date"><?php echo esc_html_x( 'The product will be available', 'Starting of this phrase: "The product will be available X days after the pre-order is placed."', 'yith-pre-order-for-woocommerce' ); ?></legend>
					<?php
					yith_plugin_fw_get_field(
						array(
							'id'                => '_ywpo_dynamic_availability_date[' . $loop . ']',
							'name'              => '_ywpo_dynamic_availability_date[' . $loop . ']',
							'type'              => 'number',
							'value'             => $dynamic_availability_date,
							'min'               => '1',
							'custom_attributes' => 'style="width:80px" autocomplete="off"',
						),
						true
					);
					?>
					<span class="ywpo_dynamic_availability_date_days_text"><?php echo esc_html_x( 'days after the pre-order is placed.', 'Ending of this phrase: "The product will be available X days after the pre-order is placed."', 'yith-pre-order-for-woocommerce' ); ?></span>
					<span class="ywpo-description"><?php esc_html_e( 'Choose how many days after the product is pre-ordered it will take for it to become available.', 'yith-pre-order-for-woocommerce' ); ?></span>
				</fieldset>
			</div>

			<fieldset class="form-field _ywpo_price_mode">
				<legend for="_ywpo_price_mode"><?php esc_html_e( 'Pre-order price', 'yith-pre-order-for-woocommerce' ); ?></legend>
				<?php
				yith_plugin_fw_get_field(
					array(
						'id'      => '_ywpo_price_mode[' . $loop . ']',
						'name'    => '_ywpo_price_mode[' . $loop . ']',
						'value'   => $price_mode,
						'type'    => 'select',
						'options' => array(
							'default'             => __( 'Use the selling price', 'yith-pre-order-for-woocommerce' ),
							'fixed'               => __( 'Set a fixed pre-order price', 'yith-pre-order-for-woocommerce' ),
							'discount_percentage' => __( 'Discount a percentage % of the selling price', 'yith-pre-order-for-woocommerce' ),
							'discount_fixed'      => __( 'Discount a fixed amount of the selling price', 'yith-pre-order-for-woocommerce' ),
							'increase_percentage' => __( 'Increase a percentage % of the selling price', 'yith-pre-order-for-woocommerce' ),
							'increase_fixed'      => __( 'Increase a fixed amount of the selling price', 'yith-pre-order-for-woocommerce' ),
						),
					),
					true
				);
				?>
			</fieldset>
			<p class="form-field yith-plugin-ui _ywpo_price_mode-description">
				<span class="description"><?php esc_html_e( 'Choose how to manage the pre-order price.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</p>

			<fieldset class="form-field _ywpo_preorder_price" data-deps-on="_ywpo_price_mode[<?php echo esc_attr( $loop ); ?>]" data-deps-val="fixed">
				<legend for="_ywpo_preorder_price"><?php echo esc_html__( 'Price', 'yith-pre-order-for-woocommerce' ) . ' (' . esc_attr( get_woocommerce_currency_symbol() ) . ')'; ?></legend>
				<?php
				yith_plugin_fw_get_field(
					array(
						'id'                => '_ywpo_preorder_price[' . $loop . ']',
						'name'              => '_ywpo_preorder_price[' . $loop . ']',
						'type'              => 'text',
						'value'             => wc_format_localized_price( $preorder_price ),
						'class'             => 'wc_input_price',
						'custom_attributes' => 'style="width:80px"',
					),
					true
				);
				?>
				<span class="ywpo-description"><?php esc_html_e( 'Set the pre-order price for this product.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</fieldset>

			<fieldset class="form-field ywpo_preorder_discount_percentage" data-deps-on="_ywpo_price_mode[<?php echo esc_attr( $loop ); ?>]" data-deps-val="discount_percentage">
				<legend for="_ywpo_preorder_discount_percentage"><?php esc_html_e( 'Discount on selling price', 'yith-pre-order-for-woocommerce' ); ?></legend>
				<span class="wrap">
					<input type="number" name="_ywpo_preorder_discount_percentage[<?php echo esc_attr( $loop ); ?>]" id="_ywpo_preorder_discount_percentage[<?php echo esc_attr( $loop ); ?>]"
					min="1" style="width: 80px; margin-right: 15px;" value="<?php echo esc_attr( $discount_percentage ); ?>" />
					<span>%</span>
				</span>
				<span class="ywpo-description"><?php esc_html_e( 'Set the pre-order price for this product.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</fieldset>

			<fieldset class="form-field ywpo_preorder_discount_fixed" data-deps-on="_ywpo_price_mode[<?php echo esc_attr( $loop ); ?>]" data-deps-val="discount_fixed">
				<legend for="_ywpo_preorder_discount_fixed"><?php esc_html_e( 'Discount on selling price', 'yith-pre-order-for-woocommerce' ); ?></legend>
				<span class="wrap">
					<input type="number" name="_ywpo_preorder_discount_fixed[<?php echo esc_attr( $loop ); ?>]" id="_ywpo_preorder_discount_fixed[<?php echo esc_attr( $loop ); ?>]"
					min="1" style="width: 80px; margin-right: 15px;" value="<?php echo esc_attr( $discount_fixed ); ?>" />
					<span><?php echo esc_html( get_woocommerce_currency_symbol() ); ?></span>
				</span>
				<span class="ywpo-description"><?php esc_html_e( 'Set the pre-order price for this product.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</fieldset>

			<fieldset class="form-field ywpo_preorder_increase_percentage" data-deps-on="_ywpo_price_mode[<?php echo esc_attr( $loop ); ?>]" data-deps-val="increase_percentage">
				<legend for="_ywpo_preorder_increase_percentage"><?php esc_html_e( 'Increase on selling price', 'yith-pre-order-for-woocommerce' ); ?></legend>
				<span class="wrap">
					<input type="number" name="_ywpo_preorder_increase_percentage[<?php echo esc_attr( $loop ); ?>]" id="_ywpo_preorder_increase_percentage[<?php echo esc_attr( $loop ); ?>]"
					min="1" style="width: 80px; margin-right: 15px;" value="<?php echo esc_attr( $increase_percentage ); ?>" />
					<span>%</span>
				</span>
				<span class="ywpo-description"><?php esc_html_e( 'Set the pre-order price for this product.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</fieldset>

			<fieldset class="form-field ywpo_preorder_increase_fixed" data-deps-on="_ywpo_price_mode[<?php echo esc_attr( $loop ); ?>]" data-deps-val="increase_fixed">
				<legend for="_ywpo_preorder_increase_fixed"><?php esc_html_e( 'Increase on selling price', 'yith-pre-order-for-woocommerce' ); ?></legend>+
				<span class="wrap">
					<input type="number" name="_ywpo_preorder_increase_fixed[<?php echo esc_attr( $loop ); ?>]" id="_ywpo_preorder_increase_fixed[<?php echo esc_attr( $loop ); ?>]"
					min="1" style="width: 80px; margin-right: 15px;" value="<?php echo esc_attr( $increase_fixed ); ?>" />
					<span><?php echo esc_html( get_woocommerce_currency_symbol() ); ?></span>
				</span>
				<span class="ywpo-description"><?php esc_html_e( 'Set the pre-order price for this product.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</fieldset>

			<fieldset class="form-field yith-plugin-ui _ywpo_max_qty_enabled onoff">
				<legend for="_ywpo_max_qty_enabled"><?php esc_html_e( 'Max quantity per user', 'yith-pre-order-for-woocommerce' ); ?></legend>
				<?php
				yith_plugin_fw_get_field(
					array(
						'id'    => '_ywpo_max_qty_enabled[' . $loop . ']',
						'name'  => '_ywpo_max_qty_enabled[' . $loop . ']',
						'type'  => 'onoff',
						'value' => $max_qty_enabled,
					),
					true
				);
				?>
				<span class="ywpo-description"><?php esc_html_e( 'Enable to limit the quantity of this pre-order product that can be purchased by the same user.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</fieldset>

			<fieldset class="form-field _ywpo_max_qty" data-deps-on="_ywpo_max_qty_enabled[<?php echo esc_attr( $loop ); ?>]" data-deps-val="yes">
				<legend for="_ywpo_max_qty"><?php esc_html_e( 'Users can pre-order a maximum of', 'yith-pre-order-for-woocommerce' ); ?></legend>
				<?php
				yith_plugin_fw_get_field(
					array(
						'id'                => '_ywpo_max_qty[' . $loop . ']',
						'name'              => '_ywpo_max_qty[' . $loop . ']',
						'type'              => 'number',
						'value'             => $max_qty,
						'custom_attributes' => 'style="width:80px" autocomplete="off"',
					),
					true
				);
				?>
			</fieldset>
			<p class="form-field yith-plugin-ui _ywpo_max_qty-description" data-deps-on="_ywpo_max_qty_enabled[<?php echo esc_attr( $loop ); ?>]" data-deps-val="yes">
				<span class="description"><?php esc_html_e( 'Set the maximum number of units of this product that can be pre-ordered by the same user.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</p>

			<fieldset class="form-field yith-plugin-ui _ywpo_override_labels onoff">
				<legend for="_ywpo_override_labels"><?php esc_html_e( 'Override text and labels', 'yith-pre-order-for-woocommerce' ); ?></legend>
				<?php
				yith_plugin_fw_get_field(
					array(
						'id'    => '_ywpo_override_labels[' . $loop . ']',
						'name'  => '_ywpo_override_labels[' . $loop . ']',
						'type'  => 'onoff',
						'value' => $override_labels,
					),
					true
				);
				?>
				<span class="ywpo-description"><?php esc_html_e( 'Enable to use different labels for availability date, pre-order button, etc. for this product.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</fieldset>

			<div class="form-field yith-plugin-ui _ywpo_preorder_label" data-deps-on="_ywpo_override_labels[<?php echo esc_attr( $loop ); ?>]" data-deps-val="yes">
				<?php
				woocommerce_wp_text_input(
					array(
						'id'          => '_ywpo_preorder_label_' . $loop,
						'name'        => '_ywpo_preorder_label[' . $loop . ']',
						'value'       => $pre_order_label,
						'label'       => '',
						'desc_tip'    => 'true',
						'description' => esc_html__( 'Set a custom label to announce this product is in pre-order mode, for example: "Pre-Order Now!". If left blank, the default label will be used: "Pre-Order".', 'yith-pre-order-for-woocommerce' ),
						'placeholder' => esc_html__( 'Pre-order now', 'yith-pre-order-for-woocommerce' ),
					)
				);
				?>
			</div>
			<p class="form-field yith-plugin-ui _ywpo_preorder_label-description" data-deps-on="_ywpo_override_labels[<?php echo esc_attr( $loop ); ?>]" data-deps-val="yes">
				<span class="description"><?php esc_html_e( 'Override the text that replaces the default "Add to cart" button label.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</p>

			<fieldset class="form-field _ywpo_preorder_availability_date_label" data-deps-on="_ywpo_override_labels[<?php echo esc_attr( $loop ); ?>]" data-deps-val="yes" style="padding-left: 250px !important;">
				<?php
				yith_plugin_fw_get_field(
					array(
						'id'            => '_ywpo_preorder_availability_date_label' . $loop,
						'name'          => '_ywpo_preorder_availability_date_label[' . $loop . ']',
						'label'         => __( 'Availability date label', 'yith-pre-order-for-woocommerce' ),
						'desc_tip'      => 'true',
						'description'   => __( 'Use {availability_date} and {availability_time} to show when the pre-order mode will end.', 'yith-pre-order-for-woocommerce' ),
						'placeholder'   => __( 'Available on: {availability_date} at {availability_time}.', 'yith-pre-order-for-woocommerce' ),
						'type'          => 'textarea-editor',
						'media_buttons' => false,
						'textarea_rows' => 5,
						'value'         => $availability_date_label,
					),
					true
				);
				?>
			</fieldset>
			<p class="form-field yith-plugin-ui _ywpo_preorder_availability_date_label-description" data-deps-on="_ywpo_override_labels[<?php echo esc_attr( $loop ); ?>]" data-deps-val="yes">
				<span class="description"><?php esc_html_e( 'Override the text that announces the pre-order availability date if an availability date has been set.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</p>

			<fieldset class="form-field _ywpo_preorder_no_date_label" data-deps-on="_ywpo_override_labels[<?php echo esc_attr( $loop ); ?>]" data-deps-val="yes" style="padding-left: 250px !important;">
				<?php
				yith_plugin_fw_get_field(
					array(
						'id'            => '_ywpo_preorder_no_date_label' . $loop,
						'name'          => '_ywpo_preorder_no_date_label[' . $loop . ']',
						'type'          => 'textarea-editor',
						'media_buttons' => false,
						'textarea_rows' => 5,
						'value'         => $no_date_label,
					),
					true
				);
				?>
			</fieldset>
			<p class="form-field yith-plugin-ui _ywpo_preorder_no_date_label-description" data-deps-on="_ywpo_override_labels[<?php echo esc_attr( $loop ); ?>]" data-deps-val="yes">
				<span class="description"><?php esc_html_e( 'Override the text that is displayed when no availability date has been set.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</p>

			<fieldset class="form-field yith-plugin-ui _ywpo_override_fee onoff">
				<legend for="_ywpo_override_fee"><?php esc_html_e( 'Override fee options', 'yith-pre-order-for-woocommerce' ); ?></legend>
				<?php
				yith_plugin_fw_get_field(
					array(
						'id'    => '_ywpo_override_fee[' . $loop . ']',
						'name'  => '_ywpo_override_fee[' . $loop . ']',
						'type'  => 'onoff',
						'value' => $override_fee,
					),
					true
				);
				?>
				<span class="ywpo-description"><?php esc_html_e( 'Enable to use different fee options only for this product.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</fieldset>

			<fieldset class="form-field _ywpo_fee" data-deps-on="_ywpo_override_fee[<?php echo esc_attr( $loop ); ?>]" data-deps-val="yes">
				<legend for="_ywpo_preorder_price"><?php echo esc_html__( 'Fee', 'yith-pre-order-for-woocommerce' ) . ' (' . esc_attr( get_woocommerce_currency_symbol() ) . ')'; ?></legend>
				<?php
				yith_plugin_fw_get_field(
					array(
						'id'                => '_ywpo_fee[' . $loop . ']',
						'name'              => '_ywpo_fee[' . $loop . ']',
						'type'              => 'text',
						'value'             => wc_format_localized_price( $fee ),
						'class'             => 'wc_input_price',
						'custom_attributes' => 'style="width:80px" autocomplete="off"',
					),
					true
				);
				?>
				<span class="ywpo-description"><?php esc_html_e( 'Set the fee that users have to pay for this product.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</fieldset>

			<fieldset class="form-field yith-plugin-ui _ywpo_override_charge_type onoff">
				<legend for="_ywpo_override_charge_type"><?php esc_html_e( 'Override payment options', 'yith-pre-order-for-woocommerce' ); ?></legend>
				<?php
				yith_plugin_fw_get_field(
					array(
						'id'    => '_ywpo_override_charge_type[' . $loop . ']',
						'name'  => '_ywpo_override_charge_type[' . $loop . ']',
						'type'  => 'onoff',
						'value' => $override_charge_type,
					),
					true
				);
				?>
				<span class="ywpo-description"><?php esc_html_e( 'Enable to set a different payment option only for this product.', 'yith-pre-order-for-woocommerce' ); ?></span>
			</fieldset>

			<div class="form-field _ywpo_charge_type" data-deps-on="_ywpo_override_charge_type[<?php echo esc_attr( $loop ); ?>]" data-deps-val="yes">
				<?php
				woocommerce_wp_radio(
					array(
						'label'   => __( 'Payment type', 'yith-pre-order-for-woocommerce' ),
						'value'   => $charge_type,
						'id'      => '_ywpo_charge_type[' . $loop . ']',
						'name'    => '_ywpo_charge_type[' . $loop . ']',
						'options' => array(
							'upfront'      => __( 'Upfront - when the user pre-orders the product', 'yith-pre-order-for-woocommerce' ),
							'upon_release' => __( 'Upon release - automatically after the product release (a supported payment gateway is required)', 'yith-pre-order-for-woocommerce' ),
							'pay_later'    => __( 'Pay Later gateway - manually after the product release (the customer will receive an email and will be redirected to the Checkout page to pay)', 'yith-pre-order-for-woocommerce' ),
						),
					)
				);
				?>
				<p class="form-field yith-plugin-ui _ywpo_charge_type-description">
					<span class="description"><?php esc_html_e( 'Choose how to manage the pre-orders payments.', 'yith-pre-order-for-woocommerce' ); ?></span>
				</p>
			</div>
		</div>
	</div>
</div>
