<?php
/**
 * Pay button for emails.
 *
 * @package YITH\PreOrder\Templates\Emails
 * @author  YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Vars used on this template.
 *
 * @var string $message The pending payment message.
 * @var WC_Product $_product The product object.
 * @var WC_Order   $_order The order object.
 * @var string     $item_id The order item ID.
 */

$_link = $_order->get_checkout_payment_url();
$text  = apply_filters( 'ywpo_pending_payment_button_text', __( 'Pay for the item', 'yith-pre-order-for-woocommerce' ), $_product, $_order, $item_id );

if ( ! empty( $message ) ) {
	echo '<p>' . esc_html( apply_filters( 'ywpo_pending_payment_message', $message, $_product, $_order, $item_id ) ) . '</p>';
}
?>
<div>
	<?php $color = apply_filters( 'ywpo_pending_payment_message', get_option( 'woocommerce_email_base_color', '#96588a' ) ); ?>
	<a class="ywpo-pay-for-order-button" href="<?php echo esc_url( $_link ); ?>" style="padding: 15px 30px;
		line-height: 50px; background-color: <?php echo esc_html( $color ); ?>; text-decoration: none; border-radius: 7px;
		color: white;"><?php echo esc_html( $text ); ?></a>
</div>
<?php
