<?php
/**
 * Pre-order error notice.
 *
 * @package YITH\PreOrder\Notices
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Vars used on this template.
 *
 * @var array $notices Array of Pre-order error notices.
 */

if ( ! $notices ) {
	return;
}

?>
<div class="ywpo-error woocommerce-error">
	<span class="ywpo-error-icon"></span>
	<div class="ywpo-error-header"><strong><?php echo wp_kses_post( apply_filters( 'ywpo_error_header', __( 'Important message about items in your cart', 'yith-pre-order-for-woocommerce' ), $notices ) ); ?></strong></div>
	<?php do_action( 'ywpo_error_before_message', $notices ); ?>
	<?php foreach ( $notices as $notice ) : ?>
	<?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		<div class="ywpo-error-message"><?php echo wc_kses_notice( $notice['notice'] ); ?></div>
	<?php endforeach; ?>
	<?php do_action( 'ywpo_error_after_message', $notices ); ?>
</div>
