<?php
/**
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package YITH\PreOrder\Includes\Elementor
 * @author YITH <plugins@yithemes.com>
 */

use Elementor\Controls_Manager;

/**
 * YITH_Pre_Order_Availability_Date_Elementor_Widget class.
 */
class YITH_Pre_Order_Availability_Date_Elementor_Widget extends \Elementor\Widget_Base {

	/**
	 * Get element name.
	 *
	 * @return string
	 */
	public function get_name() {
		return 'yith-pre-order-availability-date';
	}

	/**
	 * Get the element title.
	 *
	 * @return string
	 */
	public function get_title() {
		return esc_html__( 'YITH Pre-Order - Availability Date', 'yith-pre-order-for-woocommerce' );
	}

	/**
	 * Get the element icon.
	 *
	 * @return string
	 */
	public function get_icon() {
		return 'eicon-product-stock';
	}

	/**
	 * Get widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'yith', 'woocommerce-elements-single' );
	}

	/**
	 * Get widget keywords.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return array( 'woocommerce', 'shop', 'store', 'pre-order', 'availability', 'stock', 'arrival', 'date' );
	}

	/**
	 * Register the widget controls.
	 */
	public function register_controls() {
		$this->start_controls_section(
			'section_button',
			array(
				'label' => esc_html__( 'YITH Pre-Order - Availability Date', 'yith-pre-order-for-woocommerce' ),
			)
		);

		$this->add_control(
			'wc_style_warning',
			array(
				'type' => Controls_Manager::RAW_HTML,
				'raw'  => esc_html__( 'Enter the pre-order product ID to display its availability date.', 'yith-pre-order-for-woocommerce' ),
			)
		);

		$this->add_control(
			'product_id',
			array(
				'label'       => esc_html__( 'Pre-order product ID', 'yith-pre-order-for-woocommerce' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => '',
				'placeholder' => esc_html__( 'ID', 'yith-pre-order-for-woocommerce' ),
			)
		);

		$this->end_controls_section();

	}

	/**
	 * Render the content of the widget
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		wp_enqueue_style( 'ywpo-frontend', YITH_WCPO_ASSETS_URL . 'css/ywpo-frontend.css', array(), YITH_WCPO_VERSION );
		wp_enqueue_script( 'yith-wcpo-frontend-single-product' );
		if ( class_exists( 'YITH_Pre_Order_Frontend_Premium' ) ) {
			echo wp_kses_post( YITH_Pre_Order_Shortcodes()->availability_date_shortcode( $settings ) );
		}
	}

}
