<?php
/**
 * YITH_Pre_Order_WC_Stripe integration with WooCommerce Stripe Plugin
 *
 * @class   YITH_Pre_Order_WC_Stripe
 * @package YITH\PreOrder\Gateways
 * @since   2.0.0
 * @author  YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_WCPO_VERSION' ) ) {
	exit; // Exit if accessed directly.
}

//use SkyVerge\WooCommerce\PluginFramework\v5_10_7\SV_WC_Payment_Gateway;
//use SkyVerge\WooCommerce\PluginFramework\v5_10_7\SV_WC_Payment_Gateway_Direct;

/**
 * Integration class for WooCommerce Gateway Stripe.
 *
 * @extends WC_Gateway_Braintree_Credit_Card
 */
class YITH_Pre_Order_SV_WC_Payment_Gateway extends WC_Gateway_Braintree_Credit_Card {

	/** Pre-orders integration ID */
	const INTEGRATION_YITH_PRE_ORDER = 'yith_pre_order';

	/**
	 * Bootstrap class
	 *
	 * @since 4.1.0
	 *
	 * @param SV_WC_Payment_Gateway|SV_WC_Payment_Gateway_Direct $gateway gateway object.
	 */
	public function __construct() {

		parent::__construct();

		add_action( 'wc_payment_gateway_braintree_credit_card_init_integrations', array( $this, 'init_yith_pre_order_integration' ) );
//		add_action( 'wc_payment_gateway_braintree_paypal_init_integrations', array( $this, 'init_yith_pre_order_integration' ) );

		// add hooks
		$this->add_support( 'yith_pre_orders' );
		$this->add_support( 'pre_orders' );
	}

	public function init_yith_pre_order_integration() {
		$this->integrations[ self::INTEGRATION_YITH_PRE_ORDER ] = $this->build_yith_pre_order_integration();
	}

//	public function init_integrations() {
//
//		if ( $this->supports_subscriptions() ) {
//			$this->integrations[ self::INTEGRATION_SUBSCRIPTIONS ] = $this->build_subscriptions_integration();
//		}
//
//		if ( $this->supports_pre_orders() ) {
//			$this->integrations[ self::INTEGRATION_YITH_PRE_ORDER ] = $this->build_pre_orders_integration();
//		}
//
//		/**
//		 * Payment Gateway Integrations Initialized Action.
//		 *
//		 * Fired when integrations (Subscriptons/Pre-Orders) have been loaded and
//		 * initialized.
//		 *
//		 * @since 4.1.0
//		 *
//		 * @param SV_WC_Payment_Gateway_Direct $this instance
//		 */
//		do_action( 'wc_payment_gateway_' . $this->get_id() . '_init_integrations', $this );
//	}

	public function build_pre_orders_integration() {
		$payment_gateway_framework_path = $this->get_plugin()->get_payment_gateway_framework_path();
		require_once $payment_gateway_framework_path . '/integrations/class-sv-wc-payment-gateway-integration-pre-orders.php';
		return new YITH_Pre_Order_SV_WC_Payment_Gateway_Integration( $this );
	}

	/**
	 * Determines if the gateway supports Pre-Orders.
	 *
	 * A gateway supports Pre-Orders if all of the following are true:
	 *
	 * + Pre-Orders is active
	 * + tokenization is supported
	 * + tokenization is enabled
	 *
	 * Concrete gateways can override this to conditionally support Pre-Orders
	 * based on certain settings (e.g. only when CSC is not required, etc.)
	 *
	 * @since 5.0.0
	 *
	 * @return bool
	 */
	public function supports_pre_orders() {
		return $this->supports_tokenization() && $this->tokenization_enabled();
	}
}
