<?php
/**
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package YITH\PreOrder\Includes\Integrations
 * @author YITH <plugins@yithemes.com>
 */

if ( ! defined( 'YITH_WCPO_VERSION' ) ) {
	exit( 'Direct access forbidden.' );
}

if ( ! class_exists( 'YITH_Product_Countdown_Integration' ) ) {
	/**
	 * Class YITH_Product_Countdown_Integration
	 * This class manages the operations concerning the pre-order fees.
	 */
	class YITH_Product_Countdown_Integration {

		/**
		 * Main Instance
		 *
		 * @var YITH_Product_Countdown_Integration
		 */
		protected static $instance;

		/**
		 * Returns single instance of the class
		 *
		 * @return YITH_Product_Countdown_Integration
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Construct
		 */
		public function __construct() {
			add_filter( 'ywpo_style_options', array( $this, 'add_countdown_label_option' ) );
			add_filter( 'ywpc_timer_title', array( $this, 'product_countdown_label' ), 60, 3 );
		}

		/**
		 * Add the Product Countdown label option in the Style options tab.
		 *
		 * @param array $style_options The Style options array.
		 */
		public function add_countdown_label_option( $style_options ) {
			$style_options['style_pc_integration_start'] = array(
				'id'   => 'ywpo_style_pc_integration_start',
				'type' => 'sectionstart',
			);

			$style_options['style_pc_integration_title'] = array(
				'name' => __( 'YITH WooCommerce Product Countdown', 'yith-pre-order-for-woocommerce' ),
				'id'   => 'ywpo_style_integrations_title',
				'type' => 'title',
				'desc' => '',
			);

			$style_options['style_pc_integration_countdown_label'] = array(
				'name'      => __( 'Label for YITH WooCommerce Product Countdown', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'The label that will be shown next to the countdown timer. YITH WooCommerce Product Countdown is required.', 'yith-pre-order-for-woocommerce' ),
				'id'        => 'yith_wcpo_countdown_label',
				'type'      => 'yith-field',
				'yith-type' => 'text',
				'default'   => __( 'Available in', 'yith-pre-order-for-woocommerce' ),
			);

			$style_options['style_pc_integration_end'] = array(
				'id'   => 'ywpo_style_pc_integration_end',
				'type' => 'sectionend',
			);

			return $style_options;
		}

		/**
		 * Edit the countdown label and use the specific integration's option value.
		 *
		 * @param string $label      The product countdown label.
		 * @param string $before     The $item['before'] value.
		 * @param int    $product_id The product ID.
		 *
		 * @return string
		 */
		public function product_countdown_label( $label, $before, $product_id ) {
			$product = wc_get_product( $product_id );
			if ( YITH_Pre_Order_Utils::is_pre_order_active( $product ) ) {
				if ( 'date' === YITH_Pre_Order_Utils::get_availability_date_mode( $product ) ) {
					$label = get_option( 'yith_wcpo_countdown_label', __( 'Available in', 'yith-pre-order-for-woocommerce' ) );
				}
			}

			return $label;
		}
	}
}

/**
 * Unique access to instance of YITH_Product_Countdown_Integration
 *
 * @return YITH_Product_Countdown_Integration
 */
function YITH_Product_Countdown_Integration() { // phpcs:ignore WordPress.NamingConventions.ValidFunctionName.FunctionNameInvalid
	return YITH_Product_Countdown_Integration::get_instance();
}
