<?php
/**
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package YITH\PreOrder\PluginOptions
 * @author YITH <plugins@yithemes.com>
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_WCPO_VERSION' ) ) {
	exit;
}

$supported_gateways = array(
	'yith-stripe'         => array(
		'text' => 'Stripe',
		'link' => 'https://yithemes.com/themes/plugins/yith-woocommerce-stripe/?utm_source=wp-premium-dashboard&utm_medium=yith-woocommerce-pre-order&utm_campaign=integration',
	),
	'yith-stripe-connect' => array(
		'text' => 'Stripe Connect',
		'link' => 'https://yithemes.com/themes/plugins/yith-woocommerce-stripe-connect/?utm_source=wp-premium-dashboard&utm_medium=yith-woocommerce-pre-order&utm_campaign=integration',
	),
	'yith-braintree-cc'   => array(
		'text' => 'Braintree',
		'link' => 'https://yithemes.com/themes/plugins/yith-paypal-braintree-for-woocommerce/?utm_source=wp-premium-dashboard&utm_medium=yith-woocommerce-pre-order&utm_campaign=integration',
	),
	'stripe'              => array(
		'text' => 'WooCommerce Stripe Gateway',
		'link' => 'https://wordpress.org/plugins/woocommerce-gateway-stripe/?utm_source=wp-premium-dashboard&utm_medium=yith-woocommerce-pre-order&utm_campaign=integration',
	),
);

$supported_gateways_output = '';
foreach ( $supported_gateways as $key => $gateway ) {
	$supported_gateways_output .= '<a href="' . $gateway['link'] . '">' . $gateway['text'] . '</a>';
	if ( 'stripe' !== $key ) {
		$supported_gateways_output .= ', ';
	}
}

return array(
	'payment' => apply_filters(
		'ywpo_payment_options',
		array(
			'payment_options_start' => array(
				'id'   => 'ywpo_payment_options_start',
				'type' => 'sectionstart',
			),
			'payment_options_title' => array(
				'name' => esc_html__( 'Pre-Orders Payment', 'yith-pre-order-for-woocommerce' ),
				'id'   => 'ywpo_payment_options_title',
				'type' => 'title',
				'desc' => '',
			),
			'charge_type'           => array(
				'name'      => __( 'Charge pre-orders', 'yith-pre-order-for-woocommerce' ),
				'desc'      => __( 'Choose how to manage the pre-orders payments.', 'yith-pre-order-for-woocommerce' ) . '<br>'
							. __( ' To automatically charge the customer after the product release you need one of these payment gateways:', 'yith-pre-order-for-woocommerce' ) . '<br>'
							. $supported_gateways_output,
				'id'        => 'ywpo_charge_type',
				'type'      => 'yith-field',
				'yith-type' => 'radio',
				'options'   => array(
					'upfront'      => __( 'Upfront - when the user pre-orders the product', 'yith-pre-order-for-woocommerce' ),
					'upon_release' => __( 'Upon release - automatically after the product release (a supported payment gateway is required)', 'yith-pre-order-for-woocommerce' ),
					'pay_later'    => sprintf(
						// translators: %s: URL.
						__(
							'<a href="%s">Pay Later</a> gateway - manually after the product release (the customer will receive an email and will be redirected to the Checkout page to pay)',
							'yith-pre-order-for-woocommerce'
						),
						'admin.php?page=wc-settings&tab=checkout&section=ywpo_pay_later'
					),
				),
				'default'   => 'upfront',
			),
			'order_status'          => array(
				'name'      => __( 'Order status for pre-orders', 'yith-pre-order-for-woocommerce' ),
				'desc'      => sprintf(
					// translators: %s: URL.
					__(
						'Choose the order status that will be set after placing a pre-order (except for the <a href="%s">Pay Later</a> gateway). Changing this option will not affect previous orders.',
						'yith-pre-order-for-woocommerce'
					),
					'/wp-admin/admin.php?page=wc-settings&tab=checkout&section=ywpo_pay_later'
				),
				'id'        => 'ywpo_order_status',
				'type'      => 'yith-field',
				'yith-type' => 'radio',
				'options'   => array(
					'default'     => __( 'Use the default order status set by the gateway', 'yith-pre-order-for-woocommerce' ),
					'pre_ordered' => __( 'Use the pre-ordered status', 'yith-pre-order-for-woocommerce' ),
				),
				'default'   => 'default',
			),
			'payment_options_end'   => array(
				'id'   => 'ywpo_payment_options_end',
				'type' => 'sectionend',
			),
		)
	),
);
