<?php
/**
 * Edit product Pre-Order tab options
 *
 * @package YITH\PreOrder\Templates\Admin
 * @since   2.0.0
 * @author  YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Vars used on this template.
 *
 * @var WC_Order $order_id The WC_Order ID.
 */

$_order = wc_get_order( $order_id );

?>
<table class="ywpo-manage-products" style="width: 100%;" data-order_id="<?php echo esc_html( $_order->get_id() ); ?>">
	<thead>
	<tr>
		<th class="ywpo-manage-products-table_status"></th>
		<th class="ywpo-manage-products-table_product-title"><?php esc_html_e( 'Product', 'yith-pre-order-for-woocommerce' ); ?></th>
		<th><?php esc_html_e( 'Availability date', 'yith-pre-order-for-woocommerce' ); ?></th>
		<th class="ywpo-manage-products-table_actions"></th>
	</tr>
	</thead>
	<tbody>
	<?php foreach ( $_order->get_items() as $item ) : ?>
		<?php if ( 'yes' === $item->get_meta( '_ywpo_item_preorder' ) ) : ?>
			<tr data-order_item_id="<?php echo esc_html( $item->get_id() ); ?>">
				<td class="ywpo-manage-products-table_status ywpo-status-column">
					<?php
					$_status = $item->get_meta( '_ywpo_item_status' );
					$message = '';
					$icon    = '';
					switch ( $_status ) {
						case 'waiting':
							$message = __( 'This pre-order item is awaiting release', 'yith-pre-order-for-woocommerce' );
							$icon    = 'time-check';
							break;
						case 'completed':
							$message = __( 'This pre-order item is completed', 'yith-pre-order-for-woocommerce' );
							$icon    = 'check-alt';
							break;
						case 'cancelled':
							$message = __( 'This pre-order item is cancelled', 'yith-pre-order-for-woocommerce' );
							$icon    = 'close-alt';
							break;
					}
					if ( $message ) :
						?>
						<span class="yith-plugin-fw__action-button ywpo_status_icon">
							<a class="yith-plugin-fw__action-button__link yith-plugin-fw__tips" data-tip="<?php echo esc_attr( $message ); ?>">
								<i class="yith-plugin-fw__action-button__icon yith-icon yith-icon-<?php echo esc_attr( $icon ); ?> ywpo-<?php echo esc_attr( $_status ); ?>"></i>
							</a>
						</span>
					<?php endif; ?>
				</td>
				<td class="ywpo-manage-products-table_product-title ywpo-product-title-column">
					<span class="ywpo-product-title"><?php echo esc_html( $item->get_name() ); ?></span>


					<input type="hidden" class="order_item_id" value="<?php echo esc_html( $item->get_id() ); ?>">
				</td>
				<td class="ywpo-manage-products-table_release-date ywpo-release-date-column">
					<span class="ywpo-release-date">
						<?php
						$release_date = $item->get_meta( '_ywpo_item_for_sale_date' );
						echo $release_date ?
							esc_html( ywpo_print_datetime( $release_date ) ) :
							esc_html__( 'N/A', 'yith-pre-order-for-woocommerce' );
						?>
					</span>
				</td>
				<td class="ywpo-manage-products-table_actions ywpo-actions-column">
					<?php
					$actions = array();

					// Hide the action buttons (complete and cancel pre-order item) for the upon release pre-orders.
					// These pre-orders must be completed/canceled in the list table action buttons.
					if ( ywpo_is_upfront_order( $_order ) ) {
						if ( 'waiting' === $item->get_meta( '_ywpo_item_status' ) ) {
							$actions['completed'] = array(
								'action' => 'ywpo-complete',
								'title'  => __( 'Force pre-order completion', 'yith-pre-order-for-woocommerce' ),
								'url'    => '#',
								'icon'   => 'check-alt',
							);
							$actions['cancel']    = array(
								'action' => 'ywpo-cancel',
								'title'  => __( 'Cancel pre-order', 'yith-pre-order-for-woocommerce' ),
								'url'    => '#',
								'icon'   => 'close-alt',
							);
						}

						$actions = apply_filters( 'ywpo_manage_products_modal_status_actions', $actions, $item );
						foreach ( $actions as $_action ) {
							$_action['type'] = 'action-button';
							yith_plugin_fw_get_component( $_action );
						}
					}
					?>
				</td>
			</tr>
		<?php endif; ?>
	<?php endforeach; ?>
	</tbody>
</table>
