<?php
/**
 * Email template
 *
 * @package YITH\PreOrder\Templates\Emails
 * @author  YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Vars used on this template.
 *
 * @var string $email_heading The email heading.
 * @var YITH_Pre_Order_Out_Of_Stock_Email $email The WC_Email object.
 */

do_action( 'woocommerce_email_header', $email_heading, $email );

$body     = ! empty( $email->email_body ) ? $email->email_body : '';
$_product = $email->product;

$product_table = wc_get_template_html(
	'emails/ywpo-product-table.php',
	array(
		'_product' => $_product,
		'_order'   => '',
		'item_id'  => '',
		'context'  => 'out-of-stock',
	),
	'',
	YITH_WCPO_TEMPLATE_PATH
);

do_action( 'ywpo_out_of_stock_email_before_body', $email, $body, $_product, $product_table );

echo wp_kses_post(
	apply_filters(
		'ywpo_out_of_stock_email_body',
		'<p>' . str_replace( array( '{product_table}' ), array( $product_table ), nl2br( $body ) ) . '</p>',
		$email,
		$body,
		$_product,
		$product_table
	)
);

do_action( 'ywpo_out_of_stock_email_after_body', $email, $body, $_product, $product_table );

do_action( 'woocommerce_email_footer' );
